/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;

public class SingularIOUtils {
    private static final String[] SUFFIXES = new String[]{"B", "KB", "MB", "GB", "TB"};
    private static final String[] TIME_SYMBOS = new String[]{"seconds", "minutes", "hours", "days"};

    private SingularIOUtils() {
    }

    @Nonnull
    public static String humanReadableByteCountRound(long bytes) {
        return SingularIOUtils.humanReadableByteCountRound(bytes, true);
    }

    @Nonnull
    public static String humanReadableByteCountRound(long bytes, boolean si) {
        double bytesSize;
        int posSufix = 0;
        int unit = si ? 1000 : 1024;
        for (bytesSize = (double)bytes; bytesSize > 900.0 && posSufix < SUFFIXES.length - 1; bytesSize /= (double)unit, ++posSufix) {
        }
        return Math.round(bytesSize) + " " + SUFFIXES[posSufix];
    }

    @Nonnull
    public static String humanReadableByteCount(long bytes) {
        return SingularIOUtils.humanReadableByteCount(bytes, true);
    }

    @Nonnull
    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    @Nonnull
    public static String humanReadableMiliSeconds(long mili) {
        int pos;
        int[] unit = new int[]{60, 60, 24, 0};
        if (mili < 1000L) {
            return mili + " ms";
        }
        double value = (double)mili / 1000.0;
        for (pos = 0; value >= (double)unit[pos] && pos != unit.length - 1; value /= (double)unit[pos], ++pos) {
        }
        return String.format("%.1f %s", value, TIME_SYMBOS[pos]);
    }

    public static <T> T serializeAndDeserialize(@Nonnull T obj, boolean activeJavaDebugInfo) {
        if (activeJavaDebugInfo) {
            System.setProperty("sun.io.serialization.extendedDebugInfo", "true");
        }
        return SingularIOUtils.serializeAndDeserialize(obj);
    }

    public static <T> T serializeAndDeserialize(@Nonnull T obj) {
        try {
            ByteArrayOutputStream out1 = new ByteArrayOutputStream();
            ObjectOutputStream out2 = new ObjectOutputStream(out1);
            out2.writeObject(obj);
            out2.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out1.toByteArray()));
            return (T)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Falha no contexto da aplica\u00e7\u00e3o para serializar e deserializar o objeto", e);
        }
    }
}

