/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.lambda.IConsumerEx;
import org.opensingular.lib.commons.util.TempFileUtils;

public class TempFileProvider
implements Closeable {
    static final String DEFAULT_FILE_SUFFIX = ".tmp";
    static final String DEFAULT_FILE_PREFIX = "Singular_";
    private final Class<?> owner;
    private final List<TempEntry> tempFiles = new ArrayList<TempEntry>();

    TempFileProvider(Class<?> owner) {
        this.owner = Objects.requireNonNull(owner);
    }

    public static TempFileProvider createForUseInTryClause(@Nonnull Object requester) {
        return new TempFileProvider(TempFileProvider.resolverRequester(requester));
    }

    public static void create(@Nonnull Object requester, @Nonnull IConsumerEx<TempFileProvider, IOException> callback) {
        TempFileProvider tmp = TempFileProvider.createForUseInTryClause(requester);
        boolean hadException = true;
        try {
            callback.accept(tmp);
            hadException = false;
        }
        catch (IOException e) {
            throw SingularException.rethrow(e);
        }
        finally {
            if (hadException) {
                tmp.deleteQuietly();
            } else {
                tmp.deleteOrException();
            }
        }
    }

    private static Class<?> resolverRequester(Object requester) {
        Objects.requireNonNull(requester);
        return requester instanceof Class ? (Class<?>)requester : requester.getClass();
    }

    public boolean isEmpty() {
        return this.tempFiles.isEmpty();
    }

    public File createTempDir() {
        File f = TempFileProvider.createTempDir(DEFAULT_FILE_PREFIX);
        this.tempFiles.add(new TempEntry(f, true));
        return f;
    }

    private static File createTempDir(@Nonnull String prefix) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = prefix + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    @Nonnull
    public File createTempFile() {
        return this.createTempFile((String)null, (String)null);
    }

    @Nonnull
    public File createTempFile(@Nonnull byte[] content) {
        return this.createTempFile(new ByteArrayInputStream(content), null);
    }

    @Nonnull
    public File createTempFile(@Nonnull byte[] content, @Nullable String suffix) {
        return this.createTempFile(new ByteArrayInputStream(content), suffix);
    }

    @Nonnull
    public File createTempFile(@Nonnull InputStream content) {
        return this.createTempFile(content, null);
    }

    @Nonnull
    public File createTempFile(@Nonnull InputStream content, @Nullable String suffix) {
        File f = this.createTempFile(suffix);
        try (InputStream in = content;
             FileOutputStream fout = new FileOutputStream(f);){
            IOUtils.copy((InputStream)in, (OutputStream)fout);
        }
        catch (IOException e) {
            throw SingularException.rethrow("Erro escrevendo conte\u00fado no arquivo tempor\u00e1rio", e);
        }
        return f;
    }

    @Nonnull
    public File createTempFile(@Nullable String suffix) {
        return this.createTempFile((String)null, suffix);
    }

    @Nonnull
    public File createTempFile(@Nullable String prefix, @Nullable String suffix) {
        File f = this.createTempFileInternal(prefix, suffix);
        this.tempFiles.add(new TempEntry(f, false));
        return f;
    }

    @Nonnull
    private final File createTempFileInternal(@Nullable String prefix, @Nullable String suffix) {
        String p = prefix == null ? this.owner.getSimpleName() + '_' : prefix;
        String s = suffix == null ? DEFAULT_FILE_SUFFIX : suffix;
        try {
            return File.createTempFile(DEFAULT_FILE_PREFIX + p, s);
        }
        catch (IOException e) {
            throw SingularException.rethrow("Erro criando arquivo tempor\u00e1rio", e);
        }
    }

    public final File createTempFileByDontPutOnDeleteList(String suffix) {
        File f = this.createTempFileInternal(null, suffix);
        f.deleteOnExit();
        return f;
    }

    @Override
    public void close() {
        this.deleteOrException();
    }

    public void deleteOrException() {
        this.delete(false);
    }

    public void deleteQuietly() {
        this.delete(true);
    }

    private void delete(boolean quietly) {
        Exception error = null;
        for (TempEntry entry : this.tempFiles) {
            try {
                if (entry.diretory) {
                    this.recursiveDelete(entry.file, quietly);
                    continue;
                }
                this.deleteSingleFile(entry.file, quietly);
            }
            catch (Exception e) {
                error = e;
            }
        }
        this.tempFiles.clear();
        if (error != null) {
            throw SingularException.rethrow(error);
        }
    }

    private void recursiveDelete(File file, boolean quietly) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File each : files) {
                this.recursiveDelete(each, quietly);
            }
        }
        this.deleteSingleFile(file, quietly);
    }

    private void deleteSingleFile(File file, boolean quietly) {
        if (quietly) {
            TempFileUtils.deleteAndFailQuietily(file, this.owner);
        } else {
            TempFileUtils.deleteOrException(file, this.owner);
        }
    }

    private static class TempEntry {
        public final boolean diretory;
        public final File file;

        private TempEntry(File file, boolean diretory) {
            this.file = file;
            this.diretory = diretory;
        }
    }
}

