/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class ConversorDataISO8601 {
    private static final char DATE_TIME_SEPARATOR = 'T';
    private static final byte YEAR = 1;
    private static final byte MONTH = 2;
    private static final byte DAY = 3;
    private static final byte HOUR = 4;
    private static final byte MINUTE = 5;
    private static final byte SECONDS = 6;
    private static final byte MILLI = 7;
    private static final byte NANO = 8;

    private ConversorDataISO8601() {
    }

    public static String format(Date d) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(d);
        int mili = gc.get(14);
        byte precision = 6;
        if (mili != 0) {
            precision = 7;
        }
        return ConversorDataISO8601.format(gc.get(1), gc.get(2) + 1, gc.get(5), gc.get(11), gc.get(12), gc.get(13), mili, 0, precision);
    }

    public static Date getDate(String s) {
        return ConversorDataISO8601.getCalendar(s).getTime();
    }

    public static String format(Calendar gc) {
        return ConversorDataISO8601.format(gc.get(1), gc.get(2) + 1, gc.get(5), gc.get(11), gc.get(12), gc.get(13), gc.get(14), 0, (byte)7);
    }

    public static GregorianCalendar getCalendar(String s) {
        int[] t = ConversorDataISO8601.valueOf(s);
        GregorianCalendar gc = new GregorianCalendar(t[1], t[2] - 1, t[3], t[4], t[5], t[6]);
        if (t[8] != 0) {
            gc.set(14, t[8] / 1000000);
        }
        return gc;
    }

    private static int[] valueOf(String s) {
        if (s == null) {
            throw new IllegalArgumentException("string null");
        }
        StringReader reader = new StringReader(s);
        int[] t = new int[9];
        t[1] = reader.readNumber(4, 10, false);
        reader.readDateSeparator();
        t[2] = reader.readNumber(1, 2, false);
        reader.readDateSeparator();
        t[3] = reader.readNumber(1, 2, false);
        if (reader.isNotEnd()) {
            reader.readDateTimeSeparator();
            t[4] = reader.readNumber(1, 2, false);
            reader.readCharacter(':');
            t[5] = reader.readNumber(1, 2, false);
            if (reader.isNotEnd()) {
                reader.readCharacter(':');
                t[6] = reader.readNumber(1, 2, false);
                if (reader.hasChar('.')) {
                    t[8] = reader.readNumber(1, 9, true);
                }
            }
        }
        if (reader.isNotEnd()) {
            throw reader.errorFormat();
        }
        return t;
    }

    private static String format(int year, int month, int day, int hour, int minute, int second, int milli, int nano, byte precision) {
        StringBuilder buffer = new StringBuilder(40);
        ConversorDataISO8601.formatYearMonthDay(buffer, year, month, day);
        if (precision == 3 || ConversorDataISO8601.isTimeZero(hour, minute, second, milli, nano)) {
            return buffer.toString();
        }
        buffer.append('T');
        ConversorDataISO8601.format2(buffer, hour);
        buffer.append(':');
        ConversorDataISO8601.format2(buffer, minute);
        buffer.append(':');
        ConversorDataISO8601.format2(buffer, second);
        if (nano == 0) {
            ConversorDataISO8601.formatMilliIfNecessary(buffer, milli, precision);
        } else {
            if (milli != 0) {
                throw new IllegalArgumentException("N\u00e3o se pode para mili e nanosegundos");
            }
            ConversorDataISO8601.formatMilliAndNanoIfNecessary(buffer, nano, precision);
        }
        return buffer.toString();
    }

    private static boolean isTimeZero(int hour, int minute, int second, int milli, int nano) {
        if (hour == 0 && minute == 0 && second == 0) {
            return milli == 0 && nano == 0;
        }
        return false;
    }

    private static void formatYearMonthDay(StringBuilder buffer, int year, int month, int day) {
        if (year < 0) {
            throw new IllegalArgumentException("Ano Negativo");
        }
        if (year < 10) {
            buffer.append("000");
        } else if (year < 100) {
            buffer.append("00");
        } else if (year < 1000) {
            buffer.append('0');
        }
        buffer.append(year);
        buffer.append('-');
        ConversorDataISO8601.format2(buffer, month);
        buffer.append('-');
        ConversorDataISO8601.format2(buffer, day);
    }

    private static void formatMilliAndNanoIfNecessary(StringBuilder buffer, int nano, byte prescisao) {
        int onlyNano;
        if (nano < 0 || nano > 999999999) {
            throw new IllegalArgumentException("Nanos <0 ou >999999999");
        }
        int milli = nano / 1000000;
        ConversorDataISO8601.formatMilliIfNecessary(buffer, milli, prescisao);
        if (prescisao == 8 && (onlyNano = nano % 1000000) != 0) {
            int ultimo;
            String nanoS = Integer.toString(onlyNano);
            for (int i = 6 - nanoS.length(); i != 0; --i) {
                buffer.append('0');
            }
            for (ultimo = nanoS.length() - 1; ultimo != -1 && nanoS.charAt(ultimo) == '0'; --ultimo) {
            }
            for (int i = 0; i <= ultimo; ++i) {
                buffer.append(nanoS.charAt(i));
            }
        }
    }

    private static void format2(StringBuilder buffer, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("valor negativo");
        }
        if (value < 10) {
            buffer.append('0');
        } else if (value > 99) {
            throw new IllegalArgumentException("valor > 99");
        }
        buffer.append(value);
    }

    private static void formatMilliIfNecessary(StringBuilder buffer, int milli, byte precision) {
        if (milli < 0) {
            throw new IllegalArgumentException("Milisegundos <0");
        }
        if (milli > 999) {
            throw new IllegalArgumentException("Milisegundos >999");
        }
        if (precision == 7 || precision == 8) {
            buffer.append('.');
            if (milli < 10) {
                buffer.append("00");
            } else if (milli < 100) {
                buffer.append('0');
            }
            buffer.append(milli);
        }
    }

    public static boolean isISO8601(String value) {
        String mask = "????-??-??T??:??:??.???-??:??";
        if (value == null || value.length() < 10 || value.length() > mask.length()) {
            return false;
        }
        int tam = value.length();
        for (int i = 0; i < tam; ++i) {
            char m = mask.charAt(i);
            if (!(m == '?' ? !Character.isDigit(value.charAt(i)) : m != value.charAt(i) && (i != 10 || value.charAt(i) != ' '))) continue;
            return false;
        }
        return true;
    }

    private static class StringReader {
        private final String text;
        private int pos;

        public StringReader(String text) {
            this.text = text;
        }

        public boolean isNotEnd() {
            return this.pos != this.text.length();
        }

        public int readNumber(int minimumDigits, int maximumDigits, boolean maxShift) {
            int p = 0;
            int n = 0;
            while (this.pos < this.text.length()) {
                char c = this.text.charAt(this.pos);
                if (Character.isDigit(c)) {
                    n = p == 0 ? c - 48 : n * 10 + (c - 48);
                } else {
                    if (p != 0) break;
                    throw this.errorFormat();
                }
                ++this.pos;
                ++p;
            }
            this.validate(minimumDigits, maximumDigits, p);
            n = this.letShiftMaximo(maximumDigits, maxShift, p, n);
            return n;
        }

        protected void validate(int minimumDigits, int maximumDigits, int p) {
            if (p < minimumDigits || p > maximumDigits) {
                throw this.errorFormat();
            }
        }

        protected int letShiftMaximo(int maximumDigits, boolean maxShift, int p, int n) {
            int _n = n;
            if (maxShift) {
                for (int _p = p; _p < maximumDigits; ++_p) {
                    _n *= 10;
                }
            }
            return _n;
        }

        public void readDateSeparator() {
            char c = this.readCharacter();
            if (c != '-' && c != '.' && c != '/') {
                throw this.errorFormat();
            }
        }

        public void readDateTimeSeparator() {
            char c = this.readCharacter();
            if (c != 'T' && c != ' ') {
                throw this.errorFormat();
            }
        }

        public boolean hasChar(char c) {
            if (this.pos != this.text.length() && c == this.text.charAt(this.pos)) {
                ++this.pos;
                return true;
            }
            return false;
        }

        public void readCharacter(char c) {
            if (c != this.readCharacter()) {
                throw this.errorFormat();
            }
        }

        public char readCharacter() {
            if (this.pos == this.text.length()) {
                throw this.errorFormat();
            }
            return this.text.charAt(this.pos++);
        }

        public RuntimeException errorFormat() {
            throw new IllegalArgumentException("A string '" + this.text + "' deveria estar no formato yyyy-mm-dd hh:mm:ss.fffffffff");
        }
    }
}

