/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.opensingular.internal.lib.commons.xml.ConversorDataISO8601;
import org.opensingular.lib.commons.base.SingularException;

public final class ConversorToolkit {
    public static final Locale LOCALE = new Locale("pt", "br");
    private static DateFormat dateFormatShort__;
    private static DateFormat dateFormatMedium__;
    private static DateFormat dateFormatLong__;
    private static DateFormat dateFormatFull__;
    private static DateFormat timeFormat__;
    private static DateFormat dateTimeFormat__;
    private static final NumberFormat[] numberFormat__;

    private ConversorToolkit() {
    }

    private static void verifyNull(Object value) throws ParseException {
        if (value == null) {
            throw new ParseException("Valor nulo", 0);
        }
    }

    public static Calendar getCalendar(String data) {
        return ConversorToolkit.getCalendar(ConversorToolkit.getDateFromData(data));
    }

    public static Calendar getTime(String data) {
        return ConversorToolkit.getCalendar(ConversorToolkit.getTimeFromData(data));
    }

    public static Calendar getCalendar(Date data) {
        Calendar dt = Calendar.getInstance(LOCALE);
        dt.setLenient(false);
        dt.setTime(data);
        return dt;
    }

    private static synchronized DateFormat getDateFormat() {
        if (dateFormatMedium__ == null) {
            dateFormatMedium__ = DateFormat.getDateInstance(2, LOCALE);
            dateFormatMedium__.setLenient(false);
        }
        return dateFormatMedium__;
    }

    public static Date getDateFromData(String data) {
        if (ConversorDataISO8601.isISO8601(data)) {
            return ConversorDataISO8601.getDate(data);
        }
        try {
            ConversorToolkit.verifyNull(data);
            byte[] newBytes = data.getBytes(StandardCharsets.UTF_8);
            block5: for (int i = 0; i < newBytes.length; ++i) {
                switch (newBytes[i]) {
                    case 32: 
                    case 45: 
                    case 46: 
                    case 92: {
                        newBytes[i] = 47;
                        continue block5;
                    }
                }
            }
            if (data.length() > 8) {
                return ConversorToolkit.getDateFormat().parse(new String(newBytes, StandardCharsets.UTF_8));
            }
            return ConversorToolkit.getDateFormat("dd/MM/yy").parse(new String(newBytes, StandardCharsets.UTF_8));
        }
        catch (ParseException e) {
            throw SingularException.rethrow("Data inv\u00e1lida (" + data + "): Erro na posi\u00e7\u00e3o " + e.getErrorOffset(), e);
        }
    }

    public static Date getTimeFromData(String time) {
        try {
            ConversorToolkit.verifyNull(time);
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            return sdf.parse(time);
        }
        catch (ParseException e) {
            throw SingularException.rethrow("Hora inv\u00e1lida (" + time + ")", e);
        }
    }

    public static double getDouble(String value) throws NumberFormatException {
        if (value == null) {
            throw new NumberFormatException("Valor null");
        }
        if ("-".equals(value)) {
            return 0.0;
        }
        try {
            String v = value;
            if (v.contains(",")) {
                v = ConversorToolkit.removeCharacterFromString(v.trim(), '.');
            }
            return Double.parseDouble(v.replace(',', '.'));
        }
        catch (Exception e) {
            throw SingularException.rethrow("Valor inv\u00e1lido (" + value + ")!", e);
        }
    }

    public static int getInt(String value) throws NumberFormatException {
        if (value == null) {
            throw new NumberFormatException("Valor null");
        }
        try {
            return Integer.parseInt(ConversorToolkit.removeCharacterFromString(value.trim(), '.'));
        }
        catch (NumberFormatException e) {
            throw SingularException.rethrow("Valor inv\u00e1lido (" + value + ")!", e);
        }
    }

    public static Integer getInt(Object value) throws NumberFormatException {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return ConversorToolkit.getInt(value.toString());
        }
        return null;
    }

    private static NumberFormat getNumberFormat(int decimals) {
        if (decimals == -1) {
            return NumberFormat.getInstance(LOCALE);
        }
        if (numberFormat__[decimals] == null) {
            NumberFormat nf = NumberFormat.getInstance(LOCALE);
            nf.setMaximumFractionDigits(decimals);
            nf.setMinimumFractionDigits(decimals);
            ConversorToolkit.numberFormat__[decimals] = nf;
        }
        return numberFormat__[decimals];
    }

    public static synchronized DateFormat getDateFormat(String formato) {
        if (formato == null || "medium".equals(formato)) {
            return ConversorToolkit.getDateFormat();
        }
        if ("short".equals(formato)) {
            if (dateFormatShort__ == null) {
                dateFormatShort__ = DateFormat.getDateInstance(3, LOCALE);
                dateFormatShort__.setLenient(false);
            }
            return dateFormatShort__;
        }
        if ("long".equals(formato)) {
            if (dateFormatLong__ == null) {
                dateFormatLong__ = DateFormat.getDateInstance(1, LOCALE);
                dateFormatLong__.setLenient(false);
            }
            return dateFormatLong__;
        }
        if ("full".equals(formato)) {
            if (dateFormatFull__ == null) {
                dateFormatFull__ = DateFormat.getDateInstance(0, LOCALE);
                dateFormatFull__.setLenient(false);
            }
            return dateFormatFull__;
        }
        return new SimpleDateFormat(formato, LOCALE);
    }

    private static synchronized DateFormat getTimeFormat() {
        if (timeFormat__ == null) {
            timeFormat__ = DateFormat.getTimeInstance(2, LOCALE);
            timeFormat__.setLenient(false);
        }
        return timeFormat__;
    }

    public static String printDateTime(Date data) {
        return ConversorToolkit.printDate(data) + " " + ConversorToolkit.printHour(data);
    }

    public static String printDateTimeShortAbbreviated(Date data) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(data);
        if (cal.get(11) == 0 && cal.get(12) == 0) {
            return ConversorToolkit.printDateShort(data);
        }
        return ConversorToolkit.printDateTimeShort(data);
    }

    public static synchronized String printDateTimeShort(Date data) {
        if (data == null) {
            return null;
        }
        if (dateTimeFormat__ == null) {
            dateTimeFormat__ = DateFormat.getDateTimeInstance(3, 3, LOCALE);
            dateTimeFormat__.setLenient(false);
        }
        return dateTimeFormat__.format(data);
    }

    public static String printDate(Date data, String formato) {
        return ConversorToolkit.getDateFormat(formato).format(data);
    }

    public static String printDate(Date data) {
        if (data == null) {
            return null;
        }
        return ConversorToolkit.getDateFormat().format(data);
    }

    public static String printDateShort(Date data) {
        if (data == null) {
            return null;
        }
        return ConversorToolkit.getDateFormat("short").format(data);
    }

    public static String printDateNotNull(Date data, String formato) {
        if (data == null) {
            return "";
        }
        return ConversorToolkit.getDateFormat(formato).format(data);
    }

    public static String printDateNotNull(Date data) {
        if (data == null) {
            return "";
        }
        return ConversorToolkit.getDateFormat().format(data);
    }

    public static String printHour(Date data) {
        return ConversorToolkit.getTimeFormat().format(data);
    }

    public static String printNumber(BigDecimal bigDecimal, Integer precision) {
        DecimalFormat nf = (DecimalFormat)DecimalFormat.getInstance(LOCALE);
        nf.setParseBigDecimal(true);
        nf.setGroupingUsed(true);
        nf.setMinimumFractionDigits(precision);
        nf.setMaximumFractionDigits(precision);
        return nf.format(bigDecimal);
    }

    public static String printNumber(Double value) {
        if (value == null) {
            return null;
        }
        return ConversorToolkit.getNumberFormat(2).format(value);
    }

    public static String printNumber(double value) {
        return ConversorToolkit.getNumberFormat(2).format(value);
    }

    public static String printNumber(Double value, int qtdDecimals) {
        if (value == null) {
            return "";
        }
        return ConversorToolkit.printNumber((double)value, qtdDecimals);
    }

    public static String printNumber(double value, int qtdDecimals) {
        return ConversorToolkit.getNumberFormat(qtdDecimals).format(value);
    }

    public static String printNumber(double value, int qtdDecimals, boolean printZero) {
        if (!printZero && Double.doubleToRawLongBits(value) == 0L) {
            return "";
        }
        return ConversorToolkit.getNumberFormat(qtdDecimals).format(value);
    }

    public static String breakHtmlLines(String text) {
        return text.replace("\n", "<br/>");
    }

    private static String removeCharacterFromString(String value, char targetChar) {
        String tempValue = value;
        int i = tempValue.indexOf(targetChar);
        while (i != -1) {
            tempValue = tempValue.substring(0, i) + tempValue.substring(i + 1);
            i = tempValue.indexOf(targetChar, i);
        }
        return tempValue;
    }

    static {
        numberFormat__ = new NumberFormat[30];
    }
}

