/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class ErrorHandlerMElement
implements ErrorHandler {
    private StringBuilder buf_;

    ErrorHandlerMElement() {
    }

    private void addToBuffer(String type, SAXParseException ex) throws SAXParseException {
        if (this.buf_ == null) {
            this.buf_ = new StringBuilder(1024);
            this.buf_.append("Erro(s) efetuando parse");
        }
        this.buf_.append('\n');
        this.buf_.append(type).append(':');
        if (ex.getLineNumber() > -1) {
            this.buf_.append(" Line=").append(ex.getLineNumber());
        }
        if (ex.getColumnNumber() > -1) {
            this.buf_.append(" Col=").append(ex.getColumnNumber());
        }
        if (ex.getSystemId() != null) {
            this.buf_.append(": uri=").append(ex.getSystemId());
        }
        if (ex.getPublicId() != null) {
            this.buf_.append(": id=").append(ex.getPublicId());
        }
        if (ex.getMessage() != null) {
            this.buf_.append(": ").append(ex.getMessage());
        }
        if (ex.getException() != null) {
            throw ex;
        }
    }

    public boolean hasErros() {
        return this.buf_ != null;
    }

    public String getErros() {
        if (this.buf_ == null) {
            return null;
        }
        return this.buf_.toString();
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.addToBuffer("Error", exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.addToBuffer("FatalError", exception);
    }

    @Override
    public void warning(SAXParseException exception) {
    }
}

