/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import java.io.PrintWriter;
import java.io.Writer;
import org.json.JSONWriter;
import org.opensingular.internal.lib.commons.xml.MElementWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSONToolkit
implements MElementWriter {
    private static boolean isObject(Node node) {
        return node.getFirstChild() != null && node.getFirstChild().getNodeType() == 1;
    }

    private static boolean isProperty(Node node) {
        return node.getFirstChild() != null && node.getFirstChild().getNodeType() == 3;
    }

    private void printJSON(PrintWriter out, Element e) {
        JSONWriter jsonWriter = new JSONWriter((Writer)out);
        jsonWriter.object();
        this.printJSON(jsonWriter, (Node)e);
        jsonWriter.endObject();
    }

    private void printJSON(JSONWriter jsonWriter, Node node) {
        if (JSONToolkit.isObject(node)) {
            jsonWriter.key(node.getNodeName());
            jsonWriter.object();
            NodeList nodes = node.getChildNodes();
            for (int index = 0; index < nodes.getLength(); ++index) {
                this.printJSON(jsonWriter, nodes.item(index));
            }
            jsonWriter.endObject();
        } else if (JSONToolkit.isProperty(node)) {
            jsonWriter.key(node.getNodeName());
            jsonWriter.value((Object)node.getTextContent());
        }
    }

    @Override
    public void printDocument(PrintWriter out, Element e, boolean printHeader) {
        this.printJSON(out, e);
    }

    @Override
    public void printDocument(PrintWriter out, Element e, boolean printHeader, boolean converteEspeciais) {
        this.printJSON(out, e);
    }

    @Override
    public void printDocumentIndentado(PrintWriter out, Element e, boolean printHeader) {
        this.printJSON(out, e);
    }
}

