/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.internal.lib.commons.xml.ConversorDataISO8601;
import org.opensingular.internal.lib.commons.xml.ConversorToolkit;
import org.opensingular.internal.lib.commons.xml.JSONToolkit;
import org.opensingular.internal.lib.commons.xml.MDocument;
import org.opensingular.internal.lib.commons.xml.MElementResult;
import org.opensingular.internal.lib.commons.xml.MElementWrapper;
import org.opensingular.internal.lib.commons.xml.MElementWriter;
import org.opensingular.internal.lib.commons.xml.PrintWriterFactory;
import org.opensingular.internal.lib.commons.xml.UTF8PrintWriterFactory;
import org.opensingular.internal.lib.commons.xml.XMLMElementWriter;
import org.opensingular.internal.lib.commons.xml.XPathToolkit;
import org.opensingular.internal.lib.commons.xml.XmlUtil;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.io.StringPrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class MElement
implements Element,
Serializable {
    private final PrintWriterFactory writerFactory;
    private final MElementWriter xmlWriter;
    private final MElementWriter jsonWriter;

    protected MElement() {
        this(new UTF8PrintWriterFactory());
    }

    protected MElement(PrintWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
        this.xmlWriter = new XMLMElementWriter(StandardCharsets.UTF_8);
        this.jsonWriter = new JSONToolkit();
    }

    public static void toMElement(MElement no) {
        throw SingularException.rethrow("N\u00e3o deveria ser chamadado esse metodo com um par\u00e2metro MElement");
    }

    public static MElement toMElement(Element no) {
        if (no == null) {
            return null;
        }
        if (no instanceof MElement) {
            return (MElement)no;
        }
        return new MElementWrapper(no);
    }

    public static MElement toMElement(Node no) {
        if (no == null) {
            return null;
        }
        if (no instanceof MElement) {
            return (MElement)no;
        }
        if (!XmlUtil.isNodeTypeElement(no)) {
            throw new SingularException("no " + XPathToolkit.getFullPath(no) + " n\u00e3o \u00e9 Element");
        }
        return new MElementWrapper((Element)no);
    }

    public static MElement newInstance(Class<?> toCall) {
        return MElement.newInstance(toCall.getName().replace('.', '-'));
    }

    public static MElement newInstance(String rootName) {
        return new MElementWrapper(rootName);
    }

    public static MElement newInstance(String nameSpaceURI, String rootName) {
        return new MElementWrapper(nameSpaceURI, rootName);
    }

    static String getValueText(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                Node n = node.getFirstChild();
                if (!XmlUtil.isNodeTypeText(n)) break;
                return n.getNodeValue();
            }
            case 2: 
            case 3: {
                String value = node.getNodeValue();
                if (StringUtils.isEmpty((CharSequence)value)) break;
                return value;
            }
            default: {
                throw new SingularException("getValueText(Node) n\u00e3o trata n\u00f3 " + XPathToolkit.getNodeTypeName(node));
            }
        }
        return null;
    }

    private PrintWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public final MDocument getMDocument() {
        return MDocument.toMDocument(this.getOwnerDocument());
    }

    public final void addElement(MElement e) {
        this.appendChild(e.getOriginal());
    }

    abstract Element getOriginal();

    public final MElement addElement(String name) {
        return this.addElementNS(null, name);
    }

    public final MElement addElementNS(String namespaceURI, String qualifiedName) {
        return MElement.toMElement(MElementWrapper.addElementNS(this, namespaceURI, qualifiedName));
    }

    public final MElement addElement(String name, String value) {
        return MElement.toMElement(MElementWrapper.addElement(this, name, value));
    }

    public final MElement addElement(String name, String value, String defaultV) {
        if (value != null) {
            return this.addElement(name, value);
        }
        if (defaultV != null) {
            return this.addElement(name, defaultV);
        }
        return null;
    }

    public final MElement addElement(String name, Object o) {
        if (o == null) {
            return this.addElement(name, (String)null);
        }
        if (o instanceof String) {
            return this.addElement(name, (String)o);
        }
        if (o instanceof Integer) {
            return this.addElement(name, (Integer)o);
        }
        if (o instanceof Long) {
            return this.addElement(name, (Long)o);
        }
        if (o instanceof Double) {
            return this.addElement(name, (Double)o);
        }
        if (o instanceof Date) {
            return this.addElement(name, (Date)o);
        }
        if (o instanceof Calendar) {
            return this.addElement(name, (Calendar)o);
        }
        if (o instanceof InputStream) {
            return this.addElement(name, (InputStream)o);
        }
        if (o instanceof byte[]) {
            return this.addElement(name, (byte[])o);
        }
        return this.addElement(name, o.toString());
    }

    public final MElement addElement(String name, Object value, Object defaultV) {
        if (value != null) {
            return this.addElement(name, value);
        }
        if (defaultV != null) {
            return this.addElement(name, defaultV);
        }
        return null;
    }

    public final MElement addElement(String name, double value) {
        return this.addElement(name, Double.toString(value));
    }

    public final MElement addElement(String name, double value, int precision) {
        double m = Math.pow(10.0, precision);
        String sValue = Double.toString(Math.rint(Math.round(value * m)) / m);
        return this.addElement(name, sValue);
    }

    public final MElement addElement(String name, int value) {
        return this.addElement(name, Integer.toString(value));
    }

    public final MElement addElement(String name, long value) {
        return this.addElement(name, Long.toString(value));
    }

    public final MElement addElement(String name, byte[] value) {
        return this.addElement(name, MElementWrapper.toBASE64(value));
    }

    public final MElement addElement(String name, InputStream in) {
        return this.addElement(name, MElementWrapper.toBASE64(in, this.getWriterFactory().getCharset()));
    }

    public final MElement addBoolean(String name, boolean value) {
        if (value) {
            return this.addElement(name, Boolean.TRUE.toString());
        }
        return this.addElement(name, Boolean.FALSE.toString());
    }

    public final MElement addInt(String name, String value) {
        if (value == null) {
            return this.addElement(name, (String)null);
        }
        String s = value.trim();
        if (s.length() == 0) {
            return this.addElement(name, (String)null);
        }
        Integer.parseInt(s);
        return this.addElement(name, s);
    }

    public final MElement addInt(String name, String value, Object defaultValue) {
        String v;
        if (value != null && (v = value.trim()).length() > 0) {
            Integer.parseInt(v);
            return this.addElement(name, v);
        }
        if (defaultValue != null) {
            if (defaultValue instanceof String) {
                v = ((String)defaultValue).trim();
                if (v.length() > 0) {
                    Integer.parseInt(v);
                    return this.addElement(name, v);
                }
            } else {
                if (defaultValue instanceof Integer) {
                    return this.addElement(name, defaultValue);
                }
                throw new SingularException("Tipo default inv\u00e1lido (" + defaultValue.getClass().getName() + ") para um inteiro");
            }
        }
        return null;
    }

    public final MElement addInt(String name, String value, int defaultValue) {
        String v;
        if (value != null && (v = value.trim()).length() > 0) {
            Integer.parseInt(v);
            return this.addElement(name, v);
        }
        return this.addElement(name, defaultValue);
    }

    public final MElement addDate(String name, String value) {
        if (value == null) {
            return this.addElement(name, (String)null);
        }
        return this.addElement(name, ConversorToolkit.getDateFromData(value));
    }

    public final MElement addDate(String name, String value, String defaultValue) {
        String trim = StringUtils.trimToNull((String)value);
        if (trim == null) {
            trim = StringUtils.trimToNull((String)defaultValue);
        }
        if (trim != null) {
            return this.addElement(name, ConversorToolkit.getDateFromData(trim));
        }
        return null;
    }

    public final MElement addElement(String name, Date value) {
        if (value == null) {
            return this.addElement(name, (String)null);
        }
        return this.addElement(name, ConversorDataISO8601.format(value));
    }

    public final MElement addElement(String name, Date value, Date defaultValue) {
        if (value != null) {
            return this.addElement(name, ConversorDataISO8601.format(value));
        }
        if (defaultValue != null) {
            return this.addElement(name, ConversorDataISO8601.format(defaultValue));
        }
        return null;
    }

    public final MElement addElement(String name, Calendar value) {
        if (value == null) {
            return this.addElement(name, (String)null);
        }
        return this.addElement(name, ConversorDataISO8601.format(value));
    }

    public final Node updateNode(String xPath, String value) {
        Node n = this.getNode(xPath);
        if (n == null && !StringUtils.isEmpty((CharSequence)value)) {
            return this.addElement(xPath, value);
        }
        if (n instanceof Element) {
            if (this.updateElement(value, n)) {
                return null;
            }
        } else {
            if (n instanceof Attr) {
                return this.updateAttr(xPath, value);
            }
            return null;
        }
        return n;
    }

    protected Node updateAttr(String xPath, String value) {
        if (value == null) {
            return this.addElement(xPath, "");
        }
        return this.addElement(xPath, value);
    }

    protected boolean updateElement(String value, Node n) {
        Node filho = n.getFirstChild();
        if (filho == null) {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                Document d = n.getOwnerDocument();
                Text txt = d.createTextNode(value);
                n.appendChild(txt);
            }
        } else if (XmlUtil.isNodeTypeText(filho)) {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                filho.setNodeValue(value);
            } else {
                n.removeChild(filho);
            }
        } else {
            return true;
        }
        return false;
    }

    public final boolean possuiElement(String xPath) {
        return this.getElement(xPath) != null;
    }

    public final boolean possuiNode(String xPath) {
        return this.getNode(xPath) != null;
    }

    public final boolean isNull(String xPath) {
        return this.getValue(xPath) == null;
    }

    public final int countFilhos() {
        return this.count(null);
    }

    public final int count(String name) {
        int qtd = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!XmlUtil.isNodeTypeElement(node, name)) continue;
            ++qtd;
        }
        return qtd;
    }

    public final String getValue() {
        return MElement.getValueText(this);
    }

    public final int getInt() {
        String s = this.getValue();
        if (s == null) {
            throw new NullPointerException("Tag '" + this.getFullPath() + "' vazia");
        }
        return Integer.parseInt(s);
    }

    public final long getLong() {
        String s = this.getValue();
        if (s == null) {
            throw new NullPointerException("Tag '" + this.getFullPath() + "' vazia");
        }
        return Long.parseLong(s);
    }

    public final double getDouble() {
        String s = this.getValue();
        if (s == null) {
            throw new NullPointerException("Tag '" + this.getFullPath() + "' vazia");
        }
        return Double.parseDouble(s);
    }

    public final String getValue(String xPath) {
        return MElement.getValueText(this.getNode(xPath));
    }

    public final String getValue(String xPath, String defaultV) {
        String s = MElement.getValueText(this.getNode(xPath));
        if (s == null) {
            return defaultV;
        }
        return s;
    }

    public final String getValueNotNull(String xPath) throws NullPointerException {
        Node node = this.getNode(xPath);
        if (node == null) {
            throw new NullPointerException("xPath '" + xPath + "' n\u00e3o existe em '" + this.getFullPath() + "'");
        }
        String value = MElement.getValueText(node);
        if (value == null) {
            throw new NullPointerException("No '" + xPath + "' est\u00e1 vazio (fullPath=" + XPathToolkit.getFullPath(node) + ")");
        }
        return value;
    }

    public final List<String> getValues(String xPath) {
        return XPathToolkit.getValues(this, xPath);
    }

    public final boolean is(String xPath) {
        return this.getBoolean(xPath);
    }

    public final boolean is(String xPath, boolean defaultValue) {
        return this.getBoolean(xPath, defaultValue);
    }

    public final boolean getBoolean(String xPath) {
        String s = this.getValueNotNull(xPath);
        if (Boolean.TRUE.toString().equals(s)) {
            return true;
        }
        if (Boolean.FALSE.toString().equals(s)) {
            return false;
        }
        throw new SingularException("O valor em " + xPath + " n\u00e3o \u00e9 boolean = " + s);
    }

    public final boolean getBoolean(String xPath, boolean defaultValue) {
        String s = this.getValue(xPath);
        if (s == null) {
            return defaultValue;
        }
        if (Boolean.TRUE.toString().equals(s)) {
            return true;
        }
        if (Boolean.FALSE.toString().equals(s)) {
            return false;
        }
        throw new SingularException("O valor em " + xPath + " n\u00e3o \u00e9 boolean = " + s);
    }

    public final int getInt(String xPath) {
        return Integer.parseInt(this.getValueNotNull(xPath));
    }

    public final Integer getInteger(String xPath) {
        String s = this.getValue(xPath);
        if (s == null) {
            return null;
        }
        return Integer.valueOf(s);
    }

    public final int getInt(String xPath, int defaultV) {
        String s = this.getValue(xPath);
        if (s == null) {
            return defaultV;
        }
        return Integer.parseInt(s);
    }

    public final long getLong(String xPath) {
        return Long.parseLong(this.getValueNotNull(xPath));
    }

    public final long getLong(String xPath, long defaultV) {
        String s = this.getValue(xPath);
        if (s == null) {
            return defaultV;
        }
        return Long.parseLong(s);
    }

    public final double getDouble(String xPath) {
        return Double.parseDouble(this.getValueNotNull(xPath));
    }

    public final double getDouble(String xPath, double defaultV) {
        String s = this.getValue(xPath);
        if (s == null) {
            return defaultV;
        }
        return Double.parseDouble(s);
    }

    public final Double getDoubleObject(String xPath) {
        String s = this.getValue(xPath);
        if (s == null) {
            return null;
        }
        return new Double(s);
    }

    public final byte[] getByteBASE64(String xPath) {
        return MElementWrapper.fromBASE64(this.getValue(xPath));
    }

    public final void getByteBASE64(String xPath, OutputStream out) {
        MElementWrapper.fromBASE64(this.getValueNotNull(xPath), out);
    }

    public final Date getDate(String xPath) {
        String value = this.getValue(xPath);
        if (value == null) {
            return null;
        }
        return ConversorDataISO8601.getDate(value);
    }

    public final GregorianCalendar getCalendar(String xPath) {
        String value = this.getValue(xPath);
        if (value == null) {
            return null;
        }
        return ConversorDataISO8601.getCalendar(value);
    }

    public final String formatNumber(String xPath) {
        return ConversorToolkit.printNumber(this.getDouble(xPath, 0.0), -1, false);
    }

    public final String formatNumber(String xPath, boolean printZero) {
        return ConversorToolkit.printNumber(this.getDouble(xPath, 0.0), -1, printZero);
    }

    public final String formatNumber(String xPath, int decimals) {
        return ConversorToolkit.printNumber(this.getDouble(xPath, 0.0), decimals);
    }

    public final String formatNumber(String xPath, int decimals, boolean printZero) {
        return ConversorToolkit.printNumber(this.getDouble(xPath, 0.0), decimals, printZero);
    }

    public final String formatDate(String xPath) {
        Date d = this.getDate(xPath);
        return d == null ? "" : ConversorToolkit.printDate(d);
    }

    public final String formatDate(String xPath, String formato) {
        Date d = this.getDate(xPath);
        return d == null ? "" : ConversorToolkit.printDate(d, formato);
    }

    public final String formatHour(String xPath) {
        Date d = this.getDate(xPath);
        return d == null ? "" : ConversorToolkit.printHour(d);
    }

    public final Node getNode(String xPath) {
        return XPathToolkit.selectNode(this, xPath);
    }

    @Nonnull
    public final MElementResult selectElements(@Nullable String xPath) {
        return new MElementResult(this, xPath);
    }

    @Nonnull
    public final Iterator<MElement> iterator(@Nullable String xPath) {
        MElementResult rs = new MElementResult(this, xPath);
        return rs.iterator();
    }

    public final MElement getElement(String xPath) {
        return MElement.toMElement(XPathToolkit.selectElement(this, xPath));
    }

    @Nonnull
    public final MElement[] getElements(@Nullable String xPath) {
        return this.selectElements(xPath).getAll();
    }

    public final void copyConteudo(Element no) {
        MElementWrapper.copyElement(this, no);
    }

    public final MElement copy(Element no, String newName) {
        return MElement.toMElement(MElementWrapper.copyElement(this, no, newName));
    }

    public final String getFullPath() {
        return XPathToolkit.getFullPath(this);
    }

    public final void printTabulado(OutputStream out) {
        PrintWriter pw = this.getWriterFactory().newPrintWriter(out);
        this.xmlWriter.printDocumentIndentado(pw, this, true);
        pw.flush();
    }

    public final void printTabulado(PrintWriter out) {
        this.xmlWriter.printDocumentIndentado(out, this, true);
    }

    public final void printTabulado() {
        this.printTabulado(System.out);
    }

    public final void print(OutputStream out) {
        PrintWriter pw = this.getWriterFactory().newPrintWriter(out);
        this.xmlWriter.printDocument(pw, this, true);
        pw.flush();
    }

    public final void print(PrintWriter out) {
        this.xmlWriter.printDocument(out, this, true);
    }

    public final void print(PrintWriter out, boolean printHeader) {
        this.xmlWriter.printDocument(out, this, printHeader);
    }

    public final void print(PrintWriter out, boolean printHeader, boolean converteEspeciais) {
        this.xmlWriter.printDocument(out, this, printHeader, converteEspeciais);
    }

    public final MElement getIrmaoAnterior() {
        return this.findPreviousElement(this.getPreviousSibling(), null);
    }

    public final MElement getGemeoAnterior() {
        return this.findPreviousElement(this.getPreviousSibling(), this.getNodeName());
    }

    public final MElement getProximoIrmao() {
        return this.procurarProximoElement(this.getNextSibling(), null);
    }

    public final MElement getProximoGemeo() {
        return this.procurarProximoElement(this.getNextSibling(), this.getNodeName());
    }

    @Nullable
    public final MElement getPrimeiroFilho() {
        return this.procurarProximoElement(this.getFirstChild(), null);
    }

    public final MElement getPrimeiroFilho(String name) {
        if (name == null) {
            throw new IllegalArgumentException("O nome n\u00e3o pode ser null");
        }
        return this.procurarProximoElement(this.getFirstChild(), name);
    }

    public final MElement getUltimoFilho() {
        return this.findPreviousElement(this.getLastChild(), null);
    }

    private MElement findPreviousElement(Node no2, String name) {
        for (Node current = no2; current != null; current = current.getPreviousSibling()) {
            if (!XmlUtil.isNodeTypeElement(current, name)) continue;
            return MElement.toMElement(current);
        }
        return null;
    }

    private MElement procurarProximoElement(Node no, String name) {
        return MElement.toMElement(XmlUtil.nextSiblingOfTypeElement(no, name));
    }

    public String toString() {
        StringPrintWriter spw = this.getWriterFactory().newStringPrinWriter();
        this.printTabulado(spw);
        spw.flush();
        return spw.toString();
    }

    public final String toStringExato() {
        StringPrintWriter spw = this.getWriterFactory().newStringPrinWriter();
        this.print(spw, true, true);
        spw.flush();
        return spw.toString();
    }

    public final String toStringExato(boolean printHeader) {
        StringPrintWriter spw = this.getWriterFactory().newStringPrinWriter();
        this.print(spw, printHeader, true);
        spw.flush();
        return spw.toString();
    }

    public final byte[] toByteArray() {
        StringPrintWriter spw = this.getWriterFactory().newStringPrinWriter();
        this.print(spw);
        spw.flush();
        return spw.toByteArray();
    }

    public String toJSONString() {
        StringPrintWriter spw = this.getWriterFactory().newStringPrinWriter();
        this.jsonWriter.printDocument(spw, this, true);
        spw.flush();
        return spw.toString();
    }
}

