/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.internal.lib.commons.xml.EWrapper;
import org.opensingular.internal.lib.commons.xml.MElement;
import org.opensingular.internal.lib.commons.xml.XPathToolkit;
import org.opensingular.internal.lib.commons.xml.XmlUtil;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.internal.function.SupplierUtil;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public final class MElementResult
extends MElement
implements EWrapper {
    public static final byte VALID = 0;
    private static final byte BLOCK_START = 1;
    private static final byte BLOCK_END = 2;
    private ISupplier<Element> current;
    private byte currentState = 1;
    private final ISupplier<Element> root;
    private final String elementName;
    private final List<ISupplier<Element>> list;
    private int currentList = -1;

    public MElementResult(NodeList list) {
        if (list == null) {
            throw new IllegalArgumentException("list nula");
        }
        this.root = null;
        this.elementName = null;
        this.list = this.convert(list);
    }

    public MElementResult(Element root) {
        if (root == null) {
            throw new IllegalArgumentException("Elemento raiz nulo");
        }
        this.root = SupplierUtil.serializable(root);
        this.elementName = null;
        this.list = null;
    }

    public MElementResult(@Nonnull Element root, @Nullable String xPath) {
        if (xPath == null || XPathToolkit.isSelectSimples(xPath)) {
            this.root = SupplierUtil.serializable(root);
            this.elementName = xPath;
            this.list = null;
        } else {
            this.root = null;
            this.elementName = null;
            this.list = this.convert(XPathToolkit.selectNodeList(root, xPath));
        }
    }

    private List<ISupplier<Element>> convert(NodeList nodeList) {
        ArrayList<ISupplier<Element>> newList = new ArrayList<ISupplier<Element>>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node no = nodeList.item(i);
            if (no == null) {
                throw new SingularException("O result da consulta na posi\u00e7\u00e3o " + this.currentList + " est\u00e1 null");
            }
            if (!XmlUtil.isNodeTypeElement(no)) {
                throw new SingularException("O result da consulta na posi\u00e7\u00e3o " + this.currentList + " n\u00e3o \u00e9 um Element. \u00c9 um no do tipo " + XPathToolkit.getNodeTypeName(no));
            }
            newList.add(SupplierUtil.serializable((Element)no));
        }
        return newList;
    }

    public final MElement[] getAll() {
        ArrayList<MElement> list = new ArrayList<MElement>();
        while (this.next()) {
            list.add(this.getCurrent());
        }
        return list.toArray(new MElement[list.size()]);
    }

    public final MElement getCurrent() {
        return MElementResult.toMElement(this.getCurrentInternal());
    }

    @Override
    public final Element getOriginal() {
        Element e = this.getCurrentInternal();
        if (e instanceof EWrapper) {
            return ((EWrapper)((Object)e)).getOriginal();
        }
        return e;
    }

    private Element getCurrentInternal() {
        if (this.currentState != 0) {
            throw new IllegalStateException("O elemento atual est\u00e1 no " + (this.currentState == 1 ? "in\u00edcio" : "final") + " da lista");
        }
        return (Element)this.current.get();
    }

    public final boolean isBeforeFirst() {
        return this.currentState == 1;
    }

    public final boolean isCurrentValid() {
        return this.currentState == 0;
    }

    public final boolean isAfterLast() {
        return this.currentState == 2;
    }

    public final int count() {
        if (this.root == null) {
            return this.list.size();
        }
        return MElementResult.toMElement((Element)this.root.get()).count(this.elementName);
    }

    public final boolean hasNext() {
        if (this.currentState == 2) {
            return false;
        }
        if (this.root != null) {
            Node no = this.currentState == 1 ? ((Element)this.root.get()).getFirstChild() : ((Element)this.current.get()).getNextSibling();
            return XmlUtil.nextSiblingOfTypeElement(no, this.elementName) != null;
        }
        return this.currentList < this.list.size();
    }

    public final boolean next() {
        if (this.currentState == 2) {
            return false;
        }
        ++this.currentList;
        if (this.root != null) {
            Node node = this.currentState == 1 ? ((Element)this.root.get()).getFirstChild() : ((Element)this.current.get()).getNextSibling();
            node = XmlUtil.nextSiblingOfTypeElement(node, this.elementName);
            this.current = node == null ? null : SupplierUtil.serializable((Element)node);
        } else {
            this.current = null;
            if (this.currentList < this.list.size()) {
                this.current = this.list.get(this.currentList);
            }
        }
        this.currentState = this.current == null ? (byte)2 : (byte)0;
        return this.currentState == 0;
    }

    public Iterator<MElement> iterator() {
        return new Iterator<MElement>(){

            @Override
            public void remove() {
                Element original = MElementResult.this.getOriginal();
                Node parent = original.getParentNode();
                if (parent != null) {
                    parent.removeChild(original);
                }
            }

            @Override
            public boolean hasNext() {
                if (MElementResult.this.isBeforeFirst()) {
                    return MElementResult.this.next();
                }
                return MElementResult.this.getCurrent() != null;
            }

            @Override
            public MElement next() {
                MElement o = MElementResult.this.getCurrent();
                if (o == null) {
                    throw new NoSuchElementException();
                }
                MElementResult.this.next();
                return o;
            }
        };
    }

    @Override
    public String getTagName() {
        return this.getCurrentInternal().getTagName();
    }

    @Override
    public String getAttribute(String arg0) {
        return this.getCurrentInternal().getAttribute(arg0);
    }

    @Override
    public void setAttribute(String arg0, String arg1) throws DOMException {
        this.getCurrentInternal().setAttribute(arg0, arg1);
    }

    @Override
    public void removeAttribute(String arg0) throws DOMException {
        this.getCurrentInternal().removeAttribute(arg0);
    }

    @Override
    public Attr getAttributeNode(String arg0) {
        return this.getCurrentInternal().getAttributeNode(arg0);
    }

    @Override
    public Attr setAttributeNode(Attr arg0) throws DOMException {
        return this.getCurrentInternal().setAttributeNode(arg0);
    }

    @Override
    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        return this.getCurrentInternal().removeAttributeNode(arg0);
    }

    @Override
    public NodeList getElementsByTagName(String arg0) {
        return this.getCurrentInternal().getElementsByTagName(arg0);
    }

    @Override
    public String getAttributeNS(String arg0, String arg1) {
        return this.getCurrentInternal().getAttributeNS(arg0, arg1);
    }

    @Override
    public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
        this.getCurrentInternal().setAttributeNS(arg0, arg1, arg2);
    }

    @Override
    public void removeAttributeNS(String arg0, String arg1) throws DOMException {
        this.getCurrentInternal().removeAttributeNS(arg0, arg1);
    }

    @Override
    public Attr getAttributeNodeNS(String arg0, String arg1) {
        return this.getCurrentInternal().getAttributeNodeNS(arg0, arg1);
    }

    @Override
    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        return this.getCurrentInternal().setAttributeNodeNS(arg0);
    }

    @Override
    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        return this.getCurrentInternal().getElementsByTagNameNS(arg0, arg1);
    }

    @Override
    public boolean hasAttribute(String arg0) {
        return this.getCurrentInternal().hasAttribute(arg0);
    }

    @Override
    public boolean hasAttributeNS(String arg0, String arg1) {
        return this.getCurrentInternal().hasAttributeNS(arg0, arg1);
    }

    @Override
    public String getNodeName() {
        return this.getCurrentInternal().getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getCurrentInternal().getNodeValue();
    }

    @Override
    public void setNodeValue(String arg0) throws DOMException {
        this.getCurrentInternal().setNodeValue(arg0);
    }

    @Override
    public short getNodeType() {
        return this.getCurrentInternal().getNodeType();
    }

    @Override
    public Node getParentNode() {
        return this.getCurrentInternal().getParentNode();
    }

    @Override
    public NodeList getChildNodes() {
        return this.getCurrentInternal().getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        return this.getCurrentInternal().getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.getCurrentInternal().getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return this.getCurrentInternal().getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        return this.getCurrentInternal().getNextSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.getCurrentInternal().getAttributes();
    }

    @Override
    public Document getOwnerDocument() {
        return this.getCurrentInternal().getOwnerDocument();
    }

    @Override
    public Node insertBefore(Node arg0, Node arg1) throws DOMException {
        return this.getCurrentInternal().insertBefore(arg0, arg1);
    }

    @Override
    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        return this.getCurrentInternal().replaceChild(arg0, arg1);
    }

    @Override
    public Node removeChild(Node arg0) throws DOMException {
        return this.getCurrentInternal().removeChild(arg0);
    }

    @Override
    public Node appendChild(Node arg0) throws DOMException {
        return this.getCurrentInternal().appendChild(arg0);
    }

    @Override
    public boolean hasChildNodes() {
        return this.getCurrentInternal().hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean arg0) {
        return this.getCurrentInternal().cloneNode(arg0);
    }

    @Override
    public void normalize() {
        this.getCurrentInternal().normalize();
    }

    @Override
    public boolean isSupported(String arg0, String arg1) {
        return this.getCurrentInternal().isSupported(arg0, arg1);
    }

    @Override
    public String getNamespaceURI() {
        return this.getCurrentInternal().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.getCurrentInternal().getPrefix();
    }

    @Override
    public void setPrefix(String arg0) throws DOMException {
        this.getCurrentInternal().setPrefix(arg0);
    }

    @Override
    public String getLocalName() {
        return this.getCurrentInternal().getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return this.getCurrentInternal().hasAttributes();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return this.getCurrentInternal().getSchemaTypeInfo();
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        this.getCurrentInternal().setIdAttribute(name, isId);
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        this.getCurrentInternal().setIdAttributeNS(namespaceURI, localName, isId);
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        this.getCurrentInternal().setIdAttributeNode(idAttr, isId);
    }

    @Override
    public String getBaseURI() {
        return this.getCurrentInternal().getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return this.getCurrentInternal().compareDocumentPosition(other);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getCurrentInternal().getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.getCurrentInternal().setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.getOriginal().isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.getCurrentInternal().lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.getCurrentInternal().isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.getCurrentInternal().lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.getCurrentInternal().isEqualNode(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.getCurrentInternal().getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.getCurrentInternal().setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.getCurrentInternal().getUserData(key);
    }
}

