/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.opensingular.internal.lib.commons.xml.EWrapper;
import org.opensingular.internal.lib.commons.xml.MElement;
import org.opensingular.internal.lib.commons.xml.XPathToolkit;
import org.opensingular.internal.lib.commons.xml.XmlUtil;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.internal.function.SupplierUtil;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class MElementWrapper
extends MElement
implements EWrapper {
    static final char ELEMENT_PATH_SEPARATOR = '/';
    private static final DocumentBuilderFactory[] buiderFactory__ = new DocumentBuilderFactory[4];
    private static DocumentBuilder documentBuilder__;
    private final ISupplier<Element> original;

    MElementWrapper(Element original) {
        if (original == null) {
            throw new IllegalArgumentException("Elemento original n\u00e3o pode ser null");
        }
        this.original = original instanceof MElementWrapper ? ((MElementWrapper)original).original : SupplierUtil.serializable(original);
    }

    MElementWrapper(String rootName) {
        this.original = SupplierUtil.serializable(MElementWrapper.newRootElement(rootName));
    }

    MElementWrapper(String namespaceURI, String qualifiedName) {
        this.original = SupplierUtil.serializable(MElementWrapper.newRootElement(namespaceURI, qualifiedName));
    }

    @Override
    public final Element getOriginal() {
        return (Element)this.original.get();
    }

    static synchronized Document newDocument() {
        if (documentBuilder__ == null) {
            DocumentBuilderFactory f = MElementWrapper.getDocumentBuilderFactory(true, false);
            try {
                documentBuilder__ = f.newDocumentBuilder();
            }
            catch (Exception e) {
                throw SingularException.rethrow("N\u00e3o instancia o parser XML: ", e);
            }
        }
        return documentBuilder__.newDocument();
    }

    static Element newRootElement(String elementName) {
        Document d = MElementWrapper.newDocument();
        Element newElement = d.createElementNS(null, elementName);
        d.appendChild(newElement);
        return newElement;
    }

    public static Element newRootElement(String namespaceURI, String qualifiedName) {
        Document d = MElementWrapper.newDocument();
        Element newElement = d.createElementNS(namespaceURI, qualifiedName);
        if (qualifiedName != null && qualifiedName.length() != 0) {
            int posPrefixo = qualifiedName.indexOf(58);
            if (posPrefixo == -1) {
                newElement.setAttribute("xmlns", namespaceURI);
            } else {
                String prefixo = qualifiedName.substring(0, posPrefixo);
                newElement.setAttribute("xmlns:" + prefixo, namespaceURI);
            }
        }
        d.appendChild(newElement);
        return newElement;
    }

    static DocumentBuilderFactory getDocumentBuilderFactory(boolean namespaceAware, boolean validating) {
        int index = (namespaceAware ? 1 : 0) + (validating ? 2 : 0);
        if (buiderFactory__[index] == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(namespaceAware);
            factory.setValidating(validating);
            MElementWrapper.buiderFactory__[index] = factory;
        }
        return buiderFactory__[index];
    }

    static void copyElement(Element parent, Element node) {
        if (parent == null || node == null) {
            throw new IllegalArgumentException("Null n\u00e3o permitido");
        }
        Document doc = parent.getOwnerDocument();
        block4: for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
            switch (current.getNodeType()) {
                case 3: {
                    parent.appendChild(doc.createTextNode(current.getNodeValue()));
                    continue block4;
                }
                case 1: {
                    Element newElement = MElementWrapper.newElement(doc, (Element)current);
                    parent.appendChild(newElement);
                    MElementWrapper.copyElement(newElement, (Element)current);
                    continue block4;
                }
                default: {
                    throw new SingularException("O no do tipo " + current.getNodeType() + " n\u00e3o \u00e9 suportado");
                }
            }
        }
    }

    private static Element newElement(Document owner, Element original) {
        Element newElement = owner.createElementNS(original.getNamespaceURI(), original.getTagName());
        if (original.hasAttributes()) {
            NamedNodeMap domAttributes = original.getAttributes();
            int noOfAttributes = domAttributes.getLength();
            for (int i = 0; i < noOfAttributes; ++i) {
                Attr attr = (Attr)domAttributes.item(i);
                if (attr.getNamespaceURI() == null) {
                    newElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    continue;
                }
                newElement.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
            }
        }
        return newElement;
    }

    static Element copyElement(Element parent, Element no, String newName) {
        if (parent == null || no == null) {
            throw new IllegalArgumentException("Null n\u00e3o permitido");
        }
        Document doc = parent.getOwnerDocument();
        Element newElement = newName == null ? MElementWrapper.newElement(doc, no) : doc.createElement(newName);
        parent.appendChild(newElement);
        MElementWrapper.copyElement(newElement, no);
        return newElement;
    }

    static String toBASE64(byte[] value) {
        if (value == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(value);
    }

    public static String toBASE64(InputStream in, Charset charset) {
        if (in == null) {
            throw new IllegalArgumentException("inputstream est\u00e1 null");
        }
        return MElementWrapper.encodeFromInputStream(in, charset);
    }

    private static String encodeFromInputStream(InputStream in, Charset charset) {
        BufferedReader buff = new BufferedReader(new InputStreamReader(in, charset));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = buff.readLine()) != null) {
                builder.append(line);
                if (!buff.ready()) continue;
                builder.append("\r\n");
            }
        }
        catch (IOException e) {
            throw SingularException.rethrow("Error encoding from the input stream", e);
        }
        return Base64.getEncoder().encodeToString(builder.toString().getBytes(charset));
    }

    static byte[] fromBASE64(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        return Base64.getDecoder().decode(stringValue);
    }

    static void fromBASE64(String stringValue, OutputStream out) {
        if (stringValue == null || out == null) {
            throw new IllegalArgumentException("parametro null");
        }
        try {
            out.write(Base64.getDecoder().decode(stringValue));
        }
        catch (IOException e) {
            throw SingularException.rethrow("Error decoding from the output stream", e);
        }
    }

    static Element addElementNS(Node parent, String namespaceURI, String qualifiedName) {
        Node resolvedParent = parent;
        Document d = resolvedParent.getOwnerDocument();
        String resolvedNamespaceURI = namespaceURI;
        String resolvedQualifiedName = qualifiedName;
        int pos = resolvedQualifiedName.lastIndexOf(47);
        if (pos != -1) {
            resolvedParent = pos == 0 ? XmlUtil.getRootParent(resolvedParent) : MElementWrapper.getElementCriando(d, resolvedParent, resolvedNamespaceURI, resolvedQualifiedName.substring(0, pos));
            resolvedQualifiedName = resolvedQualifiedName.substring(pos + 1);
            resolvedNamespaceURI = null;
        }
        Element newElement = MElementWrapper.isVazio(resolvedNamespaceURI) ? MElementWrapper.addElementNSVazio(resolvedParent, d, resolvedQualifiedName) : MElementWrapper.addElementNSNaoVazio(resolvedParent, d, resolvedNamespaceURI, resolvedQualifiedName);
        resolvedParent.appendChild(newElement);
        return newElement;
    }

    private static Element addElementNSNaoVazio(Node resolvedParent, Document d, String resolvedNamespaceURI, String resolvedQualifiedName) {
        Element newElement = d.createElementNS(resolvedNamespaceURI, resolvedQualifiedName);
        if (!Objects.equals(resolvedNamespaceURI, resolvedParent.getNamespaceURI())) {
            int posPrefixo = resolvedQualifiedName.indexOf(58);
            if (posPrefixo == -1) {
                newElement.setAttribute("xmlns", resolvedNamespaceURI);
            } else {
                String prefixo = resolvedQualifiedName.substring(0, posPrefixo);
                newElement.setAttribute("xmlns:" + prefixo, resolvedNamespaceURI);
            }
        }
        return newElement;
    }

    private static Element addElementNSVazio(Node resolvedParent, Document d, String resolvedQualifiedName) {
        String resolvedNamespaceURI = resolvedParent.getNamespaceURI() != null && MElementWrapper.isVazio(resolvedParent.getPrefix()) ? resolvedParent.getNamespaceURI() : null;
        Element newElement = d.createElementNS(resolvedNamespaceURI, resolvedQualifiedName);
        return newElement;
    }

    static Element addElement(Element parent, String name, String value) {
        Element newElement;
        if (value == null) {
            throw new IllegalArgumentException("O set do valor de " + XPathToolkit.getFullPath(parent) + "/" + name + ": n\u00e3o \u00e9 permitido valor null. Se for necess\u00e1rio um element empty, utilize addElement sem par\u00e2metro valor");
        }
        String elementName = name;
        int pos = elementName.lastIndexOf(64);
        if (pos != -1) {
            String attributeName = elementName.substring(pos + 1);
            if (pos > 1 && elementName.charAt(pos - 1) == '/') {
                --pos;
            }
            if (pos > 0) {
                elementName = elementName.substring(0, pos);
                newElement = MElementWrapper.getElementCriando(parent.getOwnerDocument(), parent, null, elementName);
            } else {
                newElement = parent;
            }
            if (value.length() == 0) {
                newElement.removeAttribute(attributeName);
            } else {
                newElement.setAttribute(attributeName, value);
            }
        } else {
            newElement = MElementWrapper.addElementNS(parent, null, elementName);
            if (value.length() != 0) {
                Document d = parent.getOwnerDocument();
                Text txt = d.createTextNode(value);
                newElement.appendChild(txt);
            }
        }
        return newElement;
    }

    private static Element getElementCriando(Document d, Node parent, String namespaceURI, String qualifiedName) {
        Element n;
        Element e;
        String subTrecho = null;
        String resolvedQualifiedName = qualifiedName;
        int pos = resolvedQualifiedName.indexOf(47);
        Node resolvedParent = parent;
        if (pos != -1) {
            if (pos == 0) {
                resolvedParent = XmlUtil.getRootParent(resolvedParent);
                resolvedQualifiedName = resolvedQualifiedName.substring(1);
                pos = resolvedQualifiedName.indexOf(47);
            }
            if (pos != -1) {
                subTrecho = resolvedQualifiedName.substring(pos + 1);
                resolvedQualifiedName = resolvedQualifiedName.substring(0, pos);
            }
        }
        if ((e = (n = XmlUtil.nextSiblingOfTypeElement(resolvedParent.getFirstChild(), resolvedQualifiedName))) == null) {
            String resolvedNamespaceURI = namespaceURI;
            if (MElementWrapper.isVazio(resolvedNamespaceURI) && !MElementWrapper.isVazio(resolvedParent.getNamespaceURI()) && MElementWrapper.isVazio(resolvedParent.getPrefix())) {
                resolvedNamespaceURI = resolvedParent.getNamespaceURI();
            }
            e = d.createElementNS(resolvedNamespaceURI, resolvedQualifiedName);
            resolvedParent.appendChild(e);
        }
        if (subTrecho != null) {
            return MElementWrapper.getElementCriando(d, e, null, subTrecho);
        }
        return e;
    }

    private static boolean isVazio(String s) {
        return s == null || s.length() == 0;
    }

    @Override
    public String getTagName() {
        return ((Element)this.original.get()).getTagName();
    }

    @Override
    public String getAttribute(String arg0) {
        return ((Element)this.original.get()).getAttribute(arg0);
    }

    @Override
    public void setAttribute(String arg0, String arg1) {
        ((Element)this.original.get()).setAttribute(arg0, arg1);
    }

    @Override
    public void removeAttribute(String arg0) {
        ((Element)this.original.get()).removeAttribute(arg0);
    }

    @Override
    public Attr getAttributeNode(String arg0) {
        return ((Element)this.original.get()).getAttributeNode(arg0);
    }

    @Override
    public Attr setAttributeNode(Attr arg0) {
        return ((Element)this.original.get()).setAttributeNode(arg0);
    }

    @Override
    public Attr removeAttributeNode(Attr arg0) {
        return ((Element)this.original.get()).removeAttributeNode(arg0);
    }

    @Override
    public NodeList getElementsByTagName(String arg0) {
        return ((Element)this.original.get()).getElementsByTagName(arg0);
    }

    @Override
    public String getAttributeNS(String arg0, String arg1) {
        return ((Element)this.original.get()).getAttributeNS(arg0, arg1);
    }

    @Override
    public void setAttributeNS(String arg0, String arg1, String arg2) {
        ((Element)this.original.get()).setAttributeNS(arg0, arg1, arg2);
    }

    @Override
    public void removeAttributeNS(String arg0, String arg1) {
        ((Element)this.original.get()).removeAttributeNS(arg0, arg1);
    }

    @Override
    public Attr getAttributeNodeNS(String arg0, String arg1) {
        return ((Element)this.original.get()).getAttributeNodeNS(arg0, arg1);
    }

    @Override
    public Attr setAttributeNodeNS(Attr arg0) {
        return ((Element)this.original.get()).setAttributeNodeNS(arg0);
    }

    @Override
    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        return ((Element)this.original.get()).getElementsByTagNameNS(arg0, arg1);
    }

    @Override
    public boolean hasAttribute(String arg0) {
        return ((Element)this.original.get()).hasAttribute(arg0);
    }

    @Override
    public boolean hasAttributeNS(String arg0, String arg1) {
        return ((Element)this.original.get()).hasAttributeNS(arg0, arg1);
    }

    @Override
    public String getNodeName() {
        return ((Element)this.original.get()).getNodeName();
    }

    @Override
    public String getNodeValue() {
        return ((Element)this.original.get()).getNodeValue();
    }

    @Override
    public void setNodeValue(String arg0) {
        ((Element)this.original.get()).setNodeValue(arg0);
    }

    @Override
    public short getNodeType() {
        return ((Element)this.original.get()).getNodeType();
    }

    @Override
    public Node getParentNode() {
        return ((Element)this.original.get()).getParentNode();
    }

    @Override
    public NodeList getChildNodes() {
        return ((Element)this.original.get()).getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        return ((Element)this.original.get()).getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return ((Element)this.original.get()).getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return ((Element)this.original.get()).getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        return ((Element)this.original.get()).getNextSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return ((Element)this.original.get()).getAttributes();
    }

    @Override
    public Document getOwnerDocument() {
        return ((Element)this.original.get()).getOwnerDocument();
    }

    @Override
    public Node insertBefore(Node arg0, Node arg1) {
        return ((Element)this.original.get()).insertBefore(EWrapper.getOriginal(arg0), EWrapper.getOriginal(arg1));
    }

    @Override
    public Node replaceChild(Node arg0, Node arg1) {
        return ((Element)this.original.get()).replaceChild(EWrapper.getOriginal(arg0), arg1);
    }

    @Override
    public Node removeChild(Node arg0) {
        return ((Element)this.original.get()).removeChild(EWrapper.getOriginal(arg0));
    }

    @Override
    public Node appendChild(Node arg0) {
        return ((Element)this.original.get()).appendChild(EWrapper.getOriginal(arg0));
    }

    @Override
    public boolean hasChildNodes() {
        return ((Element)this.original.get()).hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean arg0) {
        return ((Element)this.original.get()).cloneNode(arg0);
    }

    @Override
    public void normalize() {
        ((Element)this.original.get()).normalize();
    }

    @Override
    public boolean isSupported(String arg0, String arg1) {
        return ((Element)this.original.get()).isSupported(arg0, arg1);
    }

    @Override
    public String getNamespaceURI() {
        return ((Element)this.original.get()).getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return ((Element)this.original.get()).getPrefix();
    }

    @Override
    public void setPrefix(String arg0) {
        ((Element)this.original.get()).setPrefix(arg0);
    }

    @Override
    public String getLocalName() {
        return ((Element)this.original.get()).getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return ((Element)this.original.get()).hasAttributes();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return ((Element)this.original.get()).getSchemaTypeInfo();
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        ((Element)this.original.get()).setIdAttribute(name, isId);
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        ((Element)this.original.get()).setIdAttributeNS(namespaceURI, localName, isId);
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        ((Element)this.original.get()).setIdAttributeNode(idAttr, isId);
    }

    @Override
    public String getBaseURI() {
        return ((Element)this.original.get()).getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return ((Element)this.original.get()).compareDocumentPosition(other);
    }

    @Override
    public String getTextContent() throws DOMException {
        return ((Element)this.original.get()).getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        ((Element)this.original.get()).setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(Node other) {
        return ((Element)this.original.get()).isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return ((Element)this.original.get()).lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return ((Element)this.original.get()).isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return ((Element)this.original.get()).lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return ((Element)this.original.get()).isEqualNode(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return ((Element)this.original.get()).getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return ((Element)this.original.get()).setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return ((Element)this.original.get()).getUserData(key);
    }
}

