/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.opensingular.internal.lib.commons.xml.ErrorHandlerMElement;
import org.opensingular.internal.lib.commons.xml.MElement;
import org.opensingular.internal.lib.commons.xml.MElementWrapper;
import org.opensingular.lib.commons.base.SingularException;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MParser {
    private EntityResolver entityResolver_;
    private MEntityResolver sourcesLocais_;

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver_ = entityResolver;
    }

    public void addInputSource(String systemId, InputSource source) {
        if (this.sourcesLocais_ == null) {
            this.sourcesLocais_ = new MEntityResolver();
        }
        this.sourcesLocais_.addSource(systemId, source);
    }

    public void addInputSource(String systemId, String value) {
        InputSource is = new InputSource(systemId);
        is.setCharacterStream(new StringReader(value));
        this.addInputSource(systemId, is);
    }

    public void addInputSource(String systemId, InputStream value) {
        InputSource is = new InputSource(systemId);
        is.setByteStream(value);
        this.addInputSource(systemId, is);
    }

    public void addInputSource(String systemId, Class<?> ref, String resourceName) {
        InputStream in = ref.getResourceAsStream(resourceName);
        if (in == null) {
            throw new SingularException("Nao foi encontrado o recurso '" + resourceName + "' tendo por base a classe " + ref.getName());
        }
        this.addInputSource(systemId, in);
    }

    private EntityResolver getResolver() {
        if (this.sourcesLocais_ != null) {
            return this.sourcesLocais_;
        }
        return this.entityResolver_;
    }

    public MElement parseComResolver(String xml) throws SAXException, IOException {
        InputSource is = new InputSource(new StringReader(xml));
        return MElement.toMElement(MParser.parseToElement(is, true, true, this.getResolver()));
    }

    public MElement parseComResolver(byte[] xml) throws SAXException, IOException {
        InputSource is = new InputSource(new ByteArrayInputStream(xml));
        return MElement.toMElement(MParser.parseToElement(is, true, true, this.getResolver()));
    }

    public MElement parseComResolver(InputStream in) throws SAXException, IOException {
        return MElement.toMElement(MParser.parseToElement(new InputSource(in), true, true, this.getResolver()));
    }

    public static MElement parse(String xml) throws SAXException, IOException {
        StringReader in = new StringReader(xml);
        return MElement.toMElement(MParser.parseToElement(new InputSource(in), true, false, null));
    }

    public static MElement parse(InputStream in, boolean namespaceAware, boolean validating) throws SAXException, IOException {
        return MElement.toMElement(MParser.parseToElement(new InputSource(in), namespaceAware, validating, null));
    }

    static Element parseToElement(InputSource in, boolean namespaceAware, boolean validating, EntityResolver entityResolver) throws SAXException, IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = MElementWrapper.getDocumentBuilderFactory(namespaceAware, validating);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e) {
            throw SingularException.rethrow(e.getMessage(), e);
        }
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw SingularException.rethrow("N\u00e3o instanciou o parser XML: ", e);
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        ErrorHandlerMElement eHandler = new ErrorHandlerMElement();
        builder.setErrorHandler(eHandler);
        Element result = builder.parse(in).getDocumentElement();
        result.normalize();
        if (eHandler.hasErros()) {
            throw new SAXException(eHandler.getErros());
        }
        return result;
    }

    private final class MEntityResolver
    implements EntityResolver {
        private final Map<String, InputSource> mapeamentoSourceLocal_ = new HashMap<String, InputSource>();

        private MEntityResolver() {
        }

        public void addSource(String systemId, InputSource source) {
            this.mapeamentoSourceLocal_.put(systemId, source);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource o = this.mapeamentoSourceLocal_.get(systemId);
            if (o != null) {
                return o;
            }
            if (MParser.this.entityResolver_ != null) {
                return MParser.this.entityResolver_.resolveEntity(publicId, systemId);
            }
            return null;
        }
    }
}

