/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import org.opensingular.internal.lib.commons.xml.AbstractToolkitWriter;
import org.opensingular.internal.lib.commons.xml.XmlUtil;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.Loggable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLMElementWriter
extends AbstractToolkitWriter
implements Loggable {
    private static final String SPACE = "    ";
    private final Charset charset;

    XMLMElementWriter(Charset charset) {
        this.charset = charset;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.charset.name());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Charset charset = Charset.forName((String)in.readObject());
        try {
            Field f = this.getClass().getDeclaredField("charset");
            f.setAccessible(true);
            f.set(this, charset);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    private void printAttributes(PrintWriter out, Element e) {
        NamedNodeMap map = e.getAttributes();
        int l = map.getLength();
        for (int i = 0; i < l; ++i) {
            Attr a = (Attr)map.item(i);
            out.print(" ");
            out.print(a.getName());
            out.print("=\"");
            out.print(a.getValue());
            out.print("\"");
        }
    }

    private void printAttributes(PrintWriter out, Element e, boolean htmlEncodeReserverdCharacters) {
        NamedNodeMap map = e.getAttributes();
        int l = map.getLength();
        for (int i = 0; i < l; ++i) {
            Attr a = (Attr)map.item(i);
            out.print(" ");
            out.print(a.getName());
            out.print("=\"");
            String text = a.getValue();
            if (htmlEncodeReserverdCharacters) {
                this.printConvertingSpecialCharacters(out, text.toCharArray());
            } else {
                out.print(text);
            }
            out.print("\"");
        }
    }

    @Override
    public void printDocument(PrintWriter out, Element e, boolean printHeader) {
        if (printHeader) {
            this.printHeader(out);
        }
        this.printElement(out, e);
    }

    @Override
    public void printDocument(PrintWriter out, Element e, boolean printHeader, boolean converteEspeciais) {
        if (printHeader) {
            this.printHeader(out);
        }
        this.printElement(out, e, converteEspeciais);
    }

    @Override
    public void printDocumentIndentado(PrintWriter out, Element e, boolean printHeader) {
        if (printHeader) {
            this.printHeader(out);
            out.println();
        }
        this.printElement(out, e, 0);
    }

    private void printHeader(PrintWriter out) {
        out.print("<?xml version=\"1.0\" encoding=\"");
        out.print(this.charset);
        out.print("\"?>");
    }

    private void printElement(PrintWriter out, Element e) {
        if (!e.hasChildNodes()) {
            out.print("<");
            out.print(e.getNodeName());
            this.printAttributes(out, e);
            out.print("/>");
            return;
        }
        out.print('<');
        out.print(e.getNodeName());
        this.printAttributes(out, e);
        out.print(">");
        NodeList nList = e.getChildNodes();
        int tam = nList.getLength();
        for (int i = 0; i < tam; ++i) {
            this.printNode(out, nList.item(i));
        }
        out.print("</");
        out.print(e.getNodeName());
        out.print('>');
    }

    private void printElement(PrintWriter out, Element e, boolean converteEspeciais) {
        if (!e.hasChildNodes()) {
            out.print("<");
            out.print(e.getNodeName());
            this.printAttributes(out, e, converteEspeciais);
            out.print("/>");
            return;
        }
        out.print('<');
        out.print(e.getNodeName());
        this.printAttributes(out, e, converteEspeciais);
        out.print(">");
        NodeList nList = e.getChildNodes();
        int tam = nList.getLength();
        for (int i = 0; i < tam; ++i) {
            this.printNode(out, nList.item(i), converteEspeciais);
        }
        out.print("</");
        out.print(e.getNodeName());
        out.print('>');
    }

    private void printElement(PrintWriter out, Element e, int level) {
        this.printSpace(out, level);
        if (!e.hasChildNodes()) {
            out.print('<');
            out.print(e.getNodeName());
            this.printAttributes(out, e);
            out.println("/>");
            return;
        }
        out.print('<');
        out.print(e.getNodeName());
        this.printAttributes(out, e);
        out.print(">");
        NodeList nList = e.getChildNodes();
        int tam = nList.getLength();
        if (tam != 0) {
            boolean skipLine;
            boolean bl = skipLine = tam > 1 || !XmlUtil.isNodeTypeText(nList.item(0));
            if (skipLine) {
                out.println();
            }
            for (int i = 0; i < tam; ++i) {
                this.printNode(out, nList.item(i), level + 1);
            }
            if (skipLine) {
                this.printSpace(out, level);
            }
        }
        out.print("</");
        out.print(e.getNodeName());
        out.println('>');
    }

    private void printNode(PrintWriter out, Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.printElement(out, (Element)node);
                break;
            }
            case 3: {
                out.print(node.getNodeValue());
                break;
            }
            default: {
                throw new SingularException("Tipo de n\u00f3 '" + node.getNodeName() + "' desconhecido: " + node.getNodeType());
            }
        }
    }

    private void printNode(PrintWriter out, Node node, boolean convertSpecialsCharacters) {
        switch (node.getNodeType()) {
            case 1: {
                this.printElement(out, (Element)node, convertSpecialsCharacters);
                break;
            }
            case 3: {
                String text = node.getNodeValue();
                if (convertSpecialsCharacters) {
                    this.printConvertingSpecialCharacters(out, text.toCharArray());
                    break;
                }
                out.print(node.getNodeValue());
                break;
            }
            default: {
                throw new SingularException("Tipo de n\u00f3 '" + node.getNodeName() + "' desconhecido: " + node.getNodeType());
            }
        }
    }

    private void printNode(PrintWriter out, Node node, int level) {
        switch (node.getNodeType()) {
            case 1: {
                this.printElement(out, (Element)node, level);
                break;
            }
            case 3: {
                String txt = node.getNodeValue();
                if (txt == null) break;
                if (txt.indexOf(10) == -1) {
                    out.print(txt);
                    break;
                }
                out.println();
                this.printText(out, txt, level);
                this.printSpace(out, level - 1);
                break;
            }
            default: {
                throw new SingularException("Tipo de n\u00f3 '" + node.getNodeName() + "' desconhecido: " + node.getNodeType());
            }
        }
    }

    private void printText(PrintWriter out, String txt, int level) {
        int tam = txt.length();
        int posi = 0;
        boolean consome = false;
        int consomeChar = 32;
        for (int i = 0; i < tam; ++i) {
            int c = txt.charAt(i);
            if (consome) {
                if (c == consomeChar) continue;
                consome = false;
                posi = i;
            }
            if (c == 10) {
                this.printSpace(out, level);
                out.println(txt.substring(posi, i));
                consome = true;
                consomeChar = 13;
                posi = i + 1;
                continue;
            }
            if (c != 13) continue;
            this.printSpace(out, level);
            out.println(txt.substring(posi, i));
            consome = true;
            consomeChar = 10;
            posi = i + 1;
        }
        if (posi >= tam) {
            out.println();
        } else {
            this.printSpace(out, level);
            out.println(txt.substring(posi));
        }
    }

    private void printSpace(PrintWriter out, int level) {
        String[] listOfSpaces = new String[15];
        if (level >= listOfSpaces.length) {
            for (int i = level; i != 0; --i) {
                out.print(SPACE);
            }
            return;
        }
        if (listOfSpaces[0] == null) {
            int tamBuffer = SPACE.length() * listOfSpaces.length;
            StringBuilder buf = new StringBuilder(tamBuffer);
            for (int i = 0; i < listOfSpaces.length; ++i) {
                listOfSpaces[i] = buf.toString();
                buf.append(SPACE);
            }
        }
        out.print(listOfSpaces[level]);
    }
}

