/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import com.sun.org.apache.xpath.internal.XPathAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.opensingular.internal.lib.commons.xml.EWrapper;
import org.opensingular.internal.lib.commons.xml.MElement;
import org.opensingular.internal.lib.commons.xml.MElementResult;
import org.opensingular.internal.lib.commons.xml.XmlUtil;
import org.opensingular.lib.commons.base.SingularException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public final class XPathToolkit {
    private static final Map<Short, String> NODE_LABEL_MAP = new HashMap<Short, String>();

    private XPathToolkit() {
    }

    public static String getFullPath(Node no) {
        StringBuilder buffer = new StringBuilder();
        XPathToolkit.getFullPath(buffer, no, null);
        return buffer.toString();
    }

    public static String getFullPath(Node no, Node topo) {
        StringBuilder buffer = new StringBuilder();
        XPathToolkit.getFullPath(buffer, no, topo);
        return buffer.toString();
    }

    private static void getFullPath(StringBuilder buffer, Node no, Node topo) {
        Node parent = no.getParentNode();
        if (parent == null) {
            if (no.getNodeType() == 2) {
                parent = ((Attr)no).getOwnerElement();
            }
        } else if (parent.getNodeType() == 9) {
            parent = null;
        }
        if (parent == null) {
            buffer.append('/');
        } else if (parent != topo) {
            XPathToolkit.getFullPath(buffer, parent, topo);
            buffer.append('/');
        }
        if (no != topo) {
            switch (no.getNodeType()) {
                case 1: {
                    buffer.append(no.getNodeName());
                    XPathToolkit.addElementIndex(buffer, no);
                    break;
                }
                case 2: {
                    buffer.append('@');
                    buffer.append(no.getNodeName());
                    break;
                }
            }
        }
    }

    private static void addElementIndex(StringBuilder buffer, Node e) {
        Node cursor;
        int pos = -1;
        for (cursor = e.getPreviousSibling(); cursor != null; cursor = cursor.getPreviousSibling()) {
            if (cursor.getNodeType() != e.getNodeType() || !e.getNodeName().equals(cursor.getNodeName())) continue;
            if (pos == -1) {
                pos = 2;
                continue;
            }
            ++pos;
        }
        if (pos != -1) {
            buffer.append('[').append(pos).append(']');
            return;
        }
        for (cursor = e.getNextSibling(); cursor != null; cursor = cursor.getNextSibling()) {
            if (cursor.getNodeType() != e.getNodeType() || !e.getNodeName().equals(cursor.getNodeName())) continue;
            buffer.append("[1]");
            return;
        }
    }

    public static String getNodeTypeName(Node n) {
        if (n == null) {
            return null;
        }
        String nodeLabel = NODE_LABEL_MAP.get(n.getNodeType());
        return nodeLabel != null ? nodeLabel : "Desconhecido (" + n.getClass().getName() + ") Node";
    }

    static boolean isSimples(String xPath) {
        Pattern pattern = Pattern.compile("[*\\[\\].]|::");
        return !xPath.startsWith("//") && !xPath.startsWith(":") && !pattern.matcher(xPath).find();
    }

    static boolean isSelectSimples(String xPath) {
        if (xPath == null) {
            return true;
        }
        for (int i = xPath.length() - 1; i != -1; --i) {
            switch (xPath.charAt(i)) {
                case '*': 
                case '.': 
                case '/': 
                case ':': 
                case '[': 
                case ']': {
                    return false;
                }
            }
        }
        return true;
    }

    public static Node selectNode(Node contextNode, String xPath) {
        if (XPathToolkit.isSimples(xPath)) {
            return XPathToolkit.findSimples(EWrapper.getOriginal(contextNode), xPath);
        }
        try {
            return XPathAPI.selectSingleNode(EWrapper.getOriginal(contextNode), xPath);
        }
        catch (TransformerException e) {
            throw SingularException.rethrow(e);
        }
    }

    public static Element selectElement(Node contextNode, String xPath) {
        Node result = XPathToolkit.selectNode(contextNode, xPath);
        if (result == null) {
            return null;
        }
        if (!XmlUtil.isNodeTypeElement(result)) {
            throw new SingularException("O elemento resultante (" + XPathToolkit.getFullPath(result) + ") n\u00e3o \u00e9 um Element, mas um " + XPathToolkit.getNodeTypeName(result));
        }
        return (Element)result;
    }

    public static MElementResult selectElements(Node contextNode, String xPath) {
        if (contextNode instanceof Element) {
            if (xPath == null) {
                return new MElementResult((Element)contextNode);
            }
            if (XPathToolkit.isSelectSimples(xPath)) {
                return new MElementResult((Element)contextNode, xPath);
            }
        }
        return new MElementResult(XPathToolkit.selectNodeList(contextNode, xPath));
    }

    public static List<String> getValues(Node contextNode, String xPath) {
        List<String> resultList = null;
        if (XPathToolkit.isSelectSimples(xPath)) {
            MElementResult rs = new MElementResult((Element)contextNode, xPath);
            while (rs.next()) {
                resultList = XPathToolkit.addToList(resultList, rs.getValue());
            }
        } else {
            NodeList nodesList = XPathToolkit.selectNodeList(contextNode, xPath);
            int tam = nodesList.getLength();
            for (int i = 0; i < tam; ++i) {
                resultList = XPathToolkit.addToList(resultList, MElement.getValueText(nodesList.item(i)));
            }
        }
        return resultList == null ? Collections.emptyList() : resultList;
    }

    private static List<String> addToList(List<String> list, String value) {
        List<String> newList = list;
        if (value != null) {
            if (list == null) {
                newList = new ArrayList<String>();
            }
            newList.add(value);
        }
        return newList;
    }

    public static NodeList selectNodeList(Node contextNode, String xPath) {
        try {
            return XPathAPI.selectNodeList(EWrapper.getOriginal(contextNode), xPath);
        }
        catch (TransformerException e) {
            throw SingularException.rethrow(e.getMessage(), e);
        }
    }

    public static NodeIterator selectNodeIterator(Node context, String xPath) {
        try {
            return XPathAPI.selectNodeIterator(EWrapper.getOriginal(context), xPath);
        }
        catch (TransformerException e) {
            throw SingularException.rethrow(e.getMessage(), e);
        }
    }

    private static Node findSimples(Node parent, String nodePath) {
        Node resp = parent;
        String path = nodePath;
        if (path.charAt(0) == '/') {
            resp = XmlUtil.getRootParent(resp);
            if (path.length() == 1) {
                return resp;
            }
            path = path.substring(1);
        }
        while (resp != null && path != null) {
            String elementName;
            int pos = path.indexOf(47);
            if (pos == -1) {
                elementName = path;
                path = null;
            } else {
                elementName = path.substring(0, pos);
                path = path.substring(pos + 1);
            }
            if (elementName.charAt(0) == '@') {
                if (path != null || !XmlUtil.isNodeTypeElement(resp)) {
                    throw SingularException.rethrow("O xPath '" + path + "' \u00e9 inv\u00e1lido");
                }
                return ((Element)resp).getAttributeNode(elementName.substring(1));
            }
            resp = XmlUtil.nextSiblingOfTypeElement(resp.getFirstChild(), elementName);
        }
        return resp;
    }

    static {
        NODE_LABEL_MAP.put((short)1, "Element Node");
        NODE_LABEL_MAP.put((short)3, "Text Node");
        NODE_LABEL_MAP.put((short)2, "Attribute Node");
        NODE_LABEL_MAP.put((short)4, "CData Section Node");
        NODE_LABEL_MAP.put((short)8, "Comment Node");
        NODE_LABEL_MAP.put((short)9, "Document Node");
        NODE_LABEL_MAP.put((short)11, "Document Fragment Node");
        NODE_LABEL_MAP.put((short)10, "Document Type Node");
        NODE_LABEL_MAP.put((short)5, "Entity Reference Node");
        NODE_LABEL_MAP.put((short)6, "Entity Node");
        NODE_LABEL_MAP.put((short)12, "Notation Node");
        NODE_LABEL_MAP.put((short)7, "Processing Instruction Node");
    }
}

