/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.xml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class XmlUtil {
    private XmlUtil() {
    }

    public static boolean isNodeTypeText(Node node) {
        return node != null && node.getNodeType() == 3;
    }

    public static boolean isNodeTypeElement(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    public static boolean isNodeTypeElement(Node node, String expectedElementName) {
        return XmlUtil.isNodeTypeElement(node) && (expectedElementName == null || expectedElementName.equals(node.getNodeName()));
    }

    public static Node getRootParent(Node node) {
        Node root = node;
        while (root.getParentNode() != null) {
            root = root.getParentNode();
        }
        return root;
    }

    public static Element nextSiblingOfTypeElement(Node node, String elementName) {
        for (Node n = node; n != null; n = n.getNextSibling()) {
            if (!XmlUtil.isNodeTypeElement(n, elementName)) continue;
            return (Element)n;
        }
        return null;
    }
}

