/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.lib.commons.base.PropertyEntry;
import org.opensingular.lib.commons.base.PropertySource;
import org.opensingular.lib.commons.base.SingularPropertyException;
import org.opensingular.lib.commons.lambda.ISupplierEx;
import org.opensingular.lib.commons.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyMap.class);
    private final LinkedHashMap<String, PropertyEntry> entries = new LinkedHashMap();
    private final PropertyMap parent;
    private boolean frozen;

    public PropertyMap() {
        this(null);
    }

    public PropertyMap(@Nullable PropertyMap parent) {
        this.parent = parent;
    }

    public void readProperties(@Nonnull File source) {
        if (source.exists()) {
            this.readProperties(() -> PropertiesUtils.load(source, "UTF-8"), PropertySource.of(source));
        }
    }

    public void readAllPropertiesFileFromClassPath(@Nonnull String resourceName) {
        List<URL> resources = this.findResources(resourceName);
        resources.forEach(url -> this.readProperties((URL)url));
    }

    @Nonnull
    private List<URL> findResources(@Nonnull String resourceName) {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resourceName);
            List list = EnumerationUtils.toList(resources);
            Collections.sort(list, (url1, url2) -> url1.toString().compareTo(url2.toString()));
            return list;
        }
        catch (Exception e) {
            throw new SingularPropertyException("Fail looking for resources with name '" + resourceName + "' in the classpath", e);
        }
    }

    public void readProperties(@Nonnull URL source) {
        this.readProperties(() -> PropertiesUtils.load(source, "UTF-8"), PropertySource.of(source));
    }

    private void readProperties(@Nonnull ISupplierEx<Properties, Exception> propertiesLoader, @Nonnull PropertySource<?> source) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("   Lendo arquivo de propriedades {}", source);
        }
        try {
            Properties properties = Objects.requireNonNull(propertiesLoader.get());
            this.readProperties(properties, source);
        }
        catch (Exception e) {
            SingularPropertyException e2 = new SingularPropertyException("Fail to read properties file", e);
            e2.add("source", source);
            throw e2;
        }
    }

    private void readProperties(@Nonnull Properties properties, @Nonnull PropertySource source) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.add((String)entry.getKey(), (String)entry.getValue(), source);
        }
    }

    public void add(@Nonnull String key, @Nullable String value) {
        this.add(key, value, PropertySource.UNKNOWN);
    }

    public void add(@Nonnull String key, @Nullable String value, @Nonnull PropertySource source) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(source);
        String value2 = StringUtils.trimToNull((String)value);
        if (this.frozen) {
            throw new SingularPropertyException("The properties map if frozen (locked for any further changed)");
        }
        PropertyEntry current = this.entries.get(key);
        if (current != null) {
            SingularPropertyException e = new SingularPropertyException("The property '" + key + "' is already definied. It's not allowed to have the same property set twice.");
            e.add("key", key);
            e.add("current Source", current.getSource());
            e.add("new Source", source);
            if (Objects.equals(current.getValue(), value2)) {
                e.add("values", "both are equals");
            }
            throw e;
        }
        this.entries.put(key, new PropertyEntry(key, value2, source));
    }

    @Nullable
    public String getValue(@Nonnull String key) {
        PropertyEntry entry = this.getEntry(key);
        return entry == null ? null : entry.getValue();
    }

    @Nullable
    public PropertyEntry getEntry(@Nonnull String key) {
        PropertyEntry entry = this.entries.get(key);
        if (entry == null && this.parent != null) {
            return this.parent.getEntry(key);
        }
        return entry;
    }

    public boolean containsKey(@Nonnull String key) {
        return this.entries.containsKey(key) || this.parent != null && this.parent.containsKey(key);
    }

    public void frozen() {
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    @Nonnull
    public PropertyMap consolidateAndFrozen() {
        PropertyMap map2 = new PropertyMap();
        this.copyEntries(map2.entries);
        map2.frozen();
        return map2;
    }

    private void copyEntries(LinkedHashMap<String, PropertyEntry> newMap) {
        if (this.parent != null) {
            this.parent.copyEntries(newMap);
        }
        newMap.putAll(this.entries);
    }

    @VisibleForTesting
    final int getSize() {
        return this.entries.size();
    }

    public void debugContent() {
        this.debugContent(System.out);
    }

    public void debugContent(@Nonnull Appendable out) {
        LinkedHashMultimap entriesBySource = LinkedHashMultimap.create();
        this.loadEntries((Multimap<PropertySource<?>, PropertyEntry>)entriesBySource);
        try {
            String lineSeparator = System.getProperty("line.separator");
            for (PropertySource source : entriesBySource.keySet()) {
                out.append('#').append(lineSeparator);
                out.append("#source '").append(source.getDescription()).append("'");
                out.append(lineSeparator);
                this.debugContent(entriesBySource.get((Object)source), out, lineSeparator);
            }
        }
        catch (IOException e) {
            throw new SingularPropertyException("Error writing to output", e);
        }
    }

    private void debugContent(Collection<PropertyEntry> properties, @Nonnull Appendable out, String lineSeparator) throws IOException {
        ArrayList<PropertyEntry> list = new ArrayList<PropertyEntry>(properties);
        Collections.sort(list);
        for (PropertyEntry pEntry : list) {
            out.append(pEntry.getKey()).append('=');
            if (pEntry.getValue() != null) {
                out.append(pEntry.getValue());
            }
            out.append(lineSeparator);
        }
    }

    private void loadEntries(Multimap<PropertySource<?>, PropertyEntry> entriesBySource) {
        this.entries.entrySet().forEach(entry -> entriesBySource.put(((PropertyEntry)entry.getValue()).getSource(), entry.getValue()));
        if (this.parent != null) {
            this.parent.loadEntries(entriesBySource);
        }
    }

    @VisibleForTesting
    final PropertyMap getParent() {
        return this.parent;
    }
}

