/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.base;

import java.io.File;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PropertySource<T> {
    public static final PropertySource<?> UNKNOWN = new PropertySource<String>("unkown source");
    final T source;

    private PropertySource(@Nonnull T source) {
        this.source = Objects.requireNonNull(source);
    }

    public String getDescription() {
        return this.source.toString();
    }

    @Nonnull
    public static PropertySource of(@Nonnull File file) {
        return new PropertySourceFile(file);
    }

    @Nonnull
    public static PropertySource of(@Nonnull URL url) {
        return new PropertySourceURL(url);
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.source, ((PropertySource)o).source);
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }

    @Nonnull
    public T get() {
        return this.source;
    }

    private static class PropertySourceURL
    extends PropertySource<URL> {
        private PropertySourceURL(@Nonnull URL source) {
            super(source);
        }
    }

    private static class PropertySourceFile
    extends PropertySource<File> {
        private PropertySourceFile(@Nonnull File source) {
            super(source);
        }

        @Override
        public String getDescription() {
            return ((File)this.source).getAbsolutePath();
        }
    }
}

