/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.util.Loggable;

public class SingularException
extends RuntimeException
implements Loggable {
    private List<InfoEntry> entries;

    protected SingularException() {
    }

    public SingularException(String msg) {
        super(msg);
    }

    protected SingularException(Throwable cause) {
        super(cause);
    }

    protected SingularException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public static SingularException rethrow(Throwable e) {
        return SingularException.rethrow(null, e);
    }

    public static SingularException rethrow(String message) {
        return SingularException.rethrow(message, null);
    }

    public static SingularException rethrow(String message, Throwable e) {
        if (e instanceof SingularException) {
            return (SingularException)e;
        }
        return new SingularException(message, e);
    }

    public boolean containsEntry(String label) {
        return this.entries != null && this.entries.stream().anyMatch(e -> Objects.equals(label, e.label));
    }

    public SingularException add(Object value) {
        return this.add(0, null, value);
    }

    public SingularException add(String label, Object value) {
        return this.add(0, label, value);
    }

    @Nonnull
    public SingularException add(@Nullable String label, @Nullable Supplier<?> valueSupplier) {
        Object value;
        try {
            value = valueSupplier == null ? null : valueSupplier.get();
        }
        catch (Exception e) {
            this.getLogger().debug(null, (Throwable)e);
            return this;
        }
        return this.add(0, label, value);
    }

    public SingularException add(int level, String label, Object value) {
        if (label != null || value != null) {
            if (this.entries == null) {
                this.entries = new ArrayList<InfoEntry>();
            }
            this.entries.add(new InfoEntry(level, label, value == null ? null : value.toString()));
        }
        return this;
    }

    @Override
    public String getMessage() {
        if (this.entries == null) {
            return super.getMessage();
        }
        StringBuilder msg = new StringBuilder();
        msg.append(super.getMessage());
        int max = 0;
        for (InfoEntry entry : this.entries) {
            if (entry == null || entry.label == null) continue;
            max = Math.max(max, entry.label.length());
        }
        for (InfoEntry entry : this.entries) {
            msg.append('\n');
            for (int level = 0; level <= entry.level; ++level) {
                msg.append("  ");
            }
            int i = 0;
            if (entry.label != null) {
                msg.append(entry.label);
                i = entry.label.length();
            }
            while (i < max) {
                msg.append(' ');
                ++i;
            }
            msg.append(':').append(' ');
            msg.append(entry.value);
        }
        return msg.toString();
    }

    private static final class InfoEntry
    implements Serializable {
        public final int level;
        public final String label;
        public final String value;

        public InfoEntry(int level, String label, String value) {
            this.level = level;
            this.label = label;
            this.value = value;
        }
    }
}

