/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.base;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opensingular.lib.commons.base.SingularPropertiesImpl;

public interface SingularProperties {
    public static final String SYSTEM_PROPERTY_SINGULAR_SERVER_HOME = "singular.server.home";
    public static final String HIBERNATE_GENERATOR = "flow.persistence.hibernate.generator";
    public static final String HIBERNATE_SEQUENCE_PROPERTY_PATTERN = "flow.persistence.%s.sequence";
    public static final String SINGULAR_EAGER_LOAD_FLOW_DEFINITIONS = "singular.flow.eager.load";
    public static final String SINGULAR_SEND_EMAIL = "singular.send.email";
    public static final String SINGULAR_EMAIL_TEST_RECPT = "singular.email.rcpt.test";
    public static final String SINGULAR_DEV_MODE = "singular.development";
    public static final String FILEUPLOAD_GLOBAL_MAX_REQUEST_SIZE = "singular.fileupload.global_max_request_size";
    public static final String FILEUPLOAD_GLOBAL_MAX_FILE_SIZE = "singular.fileupload.global_max_file_size";
    public static final String FILEUPLOAD_GLOBAL_MAX_FILE_COUNT = "singular.fileupload.global_max_file_count";
    public static final String FILEUPLOAD_GLOBAL_MAX_FILE_AGE = "singular.fileupload.global_max_file_age";
    public static final String FILEUPLOAD_DEFAULT_MAX_REQUEST_SIZE = "singular.fileupload.default_max_request_size";
    public static final String FILEUPLOAD_DEFAULT_MAX_FILE_SIZE = "singular.fileupload.default_max_file_size";
    public static final String USE_EMBEDDED_DATABASE = "singular.database.embedded";
    public static final String JNDI_DATASOURCE = "singular.datasource.jndi.name";
    public static final String CUSTOM_SCHEMA_NAME = "singular.custom.schema.name";
    public static final String DEFAULT_CAS_ENABLED = "singular.cas.default.enabled";
    public static final String DISABLE_AUTHORIZATION = "singular.auth.disable";
    public static final String ANALYTICS_ENABLED = "singular.analytics.enabled";
    public static final String FREEMARKER_IGNORE_ERROR = "singular.form.freemarker.ignore_error";
    public static final String REST_ALLOWED_COMMON_NAME = "singular.rest.allowed.common.name";
    public static final String UPLOAD_DIR_WS = "singular.ws.upload";
    public static final String TARGET_NAMESPACE = "singular.ws.targetnamespace";
    public static final String RECREATE_DATABASE = "singular.database.recreate";

    public static SingularProperties get() {
        return SingularPropertiesImpl.get();
    }

    @Nonnull
    public static String get(@Nonnull String key, @Nonnull String defaultValue) {
        return SingularProperties.get().getProperty(key, defaultValue);
    }

    @Nonnull
    public static String get(@Nonnull String key) {
        return SingularProperties.get().getProperty(key);
    }

    @Nonnull
    public static Optional<String> getOpt(@Nonnull String key) {
        return SingularProperties.get().getPropertyOpt(key);
    }

    @Nonnull
    public String getProperty(@Nonnull String var1);

    @Nonnull
    public Optional<String> getPropertyOpt(@Nonnull String var1);

    @Nonnull
    default public String getProperty(@Nonnull String key, @Nonnull String defaultValue) {
        Objects.requireNonNull(defaultValue);
        return this.getPropertyOpt(Objects.requireNonNull(key)).orElse(defaultValue);
    }

    public boolean isTrue(String var1);

    public boolean isFalse(String var1);

    default public String getSingularServerHome() {
        return System.getProperty(SYSTEM_PROPERTY_SINGULAR_SERVER_HOME);
    }

    public void debugContent();

    public void debugContent(@Nonnull Appendable var1);
}

