/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.base;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.lib.commons.base.PropertyEntry;
import org.opensingular.lib.commons.base.PropertyMap;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.base.SingularPropertyException;
import org.opensingular.lib.commons.context.SingularContext;
import org.opensingular.lib.commons.context.SingularSingletonStrategy;
import org.opensingular.lib.commons.lambda.IConsumerEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingularPropertiesImpl
implements SingularProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingularPropertiesImpl.class);
    private static final String DEFAULT_PROPERTIES_FILENAME = "singular-defaults.properties";
    private static final String[] PROPERTIES_FILES_NAME = new String[]{"singular.properties"};
    private volatile PropertyMap propertyMap;

    public static SingularPropertiesImpl get() {
        return (SingularPropertiesImpl)((SingularSingletonStrategy)((Object)SingularContext.get())).singletonize(SingularProperties.class, SingularPropertiesImpl::new);
    }

    private static File findConfDir() {
        String path = System.getProperty("singular.server.home");
        if (path != null) {
            File confDir;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("   Encontrado a propriedade singular.server.home={}", (Object)path);
            }
            if ((confDir = new File(path, "conf")).exists()) {
                if (!confDir.isDirectory() && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("   Era esperado que \"[singular.server.home]\\conf\" fosse um diret\u00f3rio");
                }
                return confDir;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("      N\u00e3o exite o diret\u00f3rio {}", (Object)confDir);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("true".equals(Optional.ofNullable("true").map(String::toLowerCase).orElse(null)));
    }

    public synchronized void reload() {
        LOGGER.info("Carregando configura\u00e7\u00f5es do Singular");
        PropertyMap newProperties = this.readClasspathDefaults();
        newProperties = this.readPropertiesFilesOverrides(newProperties);
        this.propertyMap = newProperties.consolidateAndFrozen();
    }

    public void setSingularServerHome(String serverHome) {
        if (serverHome != null) {
            System.setProperty("singular.server.home", serverHome);
        } else {
            System.clearProperty("singular.server.home");
        }
    }

    @Override
    @Nonnull
    public String getProperty(@Nonnull String key) {
        String value = this.getInternal(key);
        if (value == null) {
            throw new SingularPropertyException("The property '" + key + "' is not set or it's value is null.");
        }
        return value;
    }

    @Nullable
    private String getInternal(@Nonnull String key) {
        PropertyEntry entry = this.getProperties().getEntry(key);
        if (entry != null) {
            return entry.getValue();
        }
        return StringUtils.trimToNull((String)System.getProperties().getProperty(key));
    }

    @Override
    @Nonnull
    public Optional<String> getPropertyOpt(@Nonnull String key) {
        return Optional.ofNullable(this.getInternal(key));
    }

    @Override
    public boolean isTrue(String key) {
        return "true".equalsIgnoreCase(this.getInternal(key));
    }

    @Override
    public boolean isFalse(String key) {
        return "false".equalsIgnoreCase(this.getInternal(key));
    }

    @VisibleForTesting
    public void setProperty(@Nonnull String key, @Nonnull String value) {
        if (this.getProperties().isFrozen()) {
            this.propertyMap = new PropertyMap(this.getProperties());
        }
        this.propertyMap.add(key, value);
    }

    private synchronized PropertyMap getProperties() {
        if (this.propertyMap == null) {
            this.reload();
        }
        return this.propertyMap;
    }

    private PropertyMap readPropertiesFilesOverrides(PropertyMap newProperties) {
        File confDir = SingularPropertiesImpl.findConfDir();
        if (confDir == null) {
            return newProperties;
        }
        PropertyMap props = new PropertyMap(newProperties);
        for (String name : PROPERTIES_FILES_NAME) {
            props.readProperties(new File(confDir, name));
        }
        return props;
    }

    private PropertyMap readClasspathDefaults() {
        PropertyMap newProperties = new PropertyMap();
        newProperties.readAllPropertiesFileFromClassPath(DEFAULT_PROPERTIES_FILENAME);
        if (newProperties.getSize() != 0) {
            newProperties = new PropertyMap(newProperties);
        }
        for (String name : PROPERTIES_FILES_NAME) {
            newProperties.readAllPropertiesFileFromClassPath(name);
        }
        return newProperties;
    }

    @VisibleForTesting
    public synchronized void reloadAndOverrideWith(URL propertiesURL) {
        this.reload();
        PropertyMap p = new PropertyMap(this.getProperties());
        p.readProperties(propertiesURL);
        this.propertyMap = p;
    }

    @Override
    public void debugContent() {
        this.getProperties().debugContent();
    }

    @Override
    public void debugContent(@Nonnull Appendable out) {
        this.getProperties().debugContent(out);
    }

    private static class State {
        private PropertyMap propertiesBackup;
        private final Map<String, String> systemBackup = new HashMap<String, String>();

        private State() {
        }
    }

    @VisibleForTesting
    public static final class Tester {
        private Tester() {
        }

        public static <EX extends Exception> void runInSandbox(@Nonnull IConsumerEx<SingularPropertiesImpl, EX> callable) throws EX {
            Object state = Tester.saveState();
            try {
                callable.accept(SingularPropertiesImpl.get());
            }
            finally {
                Tester.restoreState(state);
            }
        }

        protected static void restoreState(Object stateObject) {
            State state = (State)stateObject;
            SingularPropertiesImpl impl = SingularPropertiesImpl.get();
            impl.setSingularServerHome((String)state.systemBackup.get("singular.server.home"));
            impl.propertyMap = state.propertiesBackup;
        }

        public static Object saveState() {
            SingularPropertiesImpl impl = SingularPropertiesImpl.get();
            State state = new State();
            state.propertiesBackup = impl.propertyMap;
            state.systemBackup.put("singular.server.home", System.getProperty("singular.server.home"));
            impl.propertyMap = new PropertyMap(impl.getProperties().consolidateAndFrozen());
            return state;
        }
    }
}

