/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.base;

import com.google.common.base.Throwables;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.Normalizer;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.opensingular.lib.commons.base.SingularException;

public final class SingularUtil {
    private SingularUtil() {
    }

    public static RuntimeException propagate(Throwable throwable) {
        Throwables.propagateIfPossible((Throwable)throwable, SingularException.class);
        throw SingularException.rethrow(throwable);
    }

    public static String toSHA1(Object object) {
        return SingularUtil.toSHA1(object.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static String toSHA1(byte[] bytes) {
        MessageDigest sha1Digest = DigestUtils.getSha1Digest();
        sha1Digest.update(bytes);
        return Hex.encodeHexString((byte[])sha1Digest.digest());
    }

    public static String convertToJavaIdentity(String original, boolean normalize) {
        return SingularUtil.convertToJavaIdentity(original, false, normalize);
    }

    public static String convertToJavaIdentity(String original, boolean firstCharacterUpperCase, boolean normalize) {
        String normalized = normalize ? SingularUtil.normalize(original) : original;
        StringBuilder sb = new StringBuilder(normalized.length());
        boolean nextUpper = false;
        for (char c : normalized.toCharArray()) {
            if (sb.length() == 0) {
                SingularUtil.appendLengthZero(firstCharacterUpperCase, sb, c);
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                nextUpper = SingularUtil.appendJavaIdentifierPart(sb, nextUpper, c);
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            nextUpper = true;
        }
        return sb.toString();
    }

    protected static boolean appendJavaIdentifierPart(StringBuilder sb, boolean nextUpper, char c) {
        char _c = c;
        if (nextUpper) {
            _c = Character.toUpperCase(_c);
        }
        sb.append(_c);
        return false;
    }

    protected static void appendLengthZero(boolean firstCharacterUpperCase, StringBuilder sb, char c) {
        char _c = c;
        if (Character.isJavaIdentifierStart(_c)) {
            _c = firstCharacterUpperCase ? Character.toUpperCase(_c) : Character.toLowerCase(_c);
            sb.append(_c);
        }
    }

    public static String normalize(String original) {
        return Normalizer.normalize(original, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    @SafeVarargs
    public static <T> boolean areEqual(T a, Object b, Function<T, Object> ... propertyFunctions) {
        if (a == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        Object typedB = b;
        for (Function<Object, Object> function : propertyFunctions) {
            Object propA = function.apply(a);
            Object propB = function.apply(typedB);
            if (!(propA == null ? propB != null : !propA.equals(propB))) continue;
            return false;
        }
        return true;
    }
}

