/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.canvas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.lib.commons.canvas.DocumentCanvas;
import org.opensingular.lib.commons.canvas.FormItem;
import org.opensingular.lib.commons.canvas.builder.RawHtmlBuilder;
import org.opensingular.lib.commons.canvas.table.HtmlTableCanvas;
import org.opensingular.lib.commons.canvas.table.TableCanvas;

public class HtmlCanvas
implements DocumentCanvas {
    private final boolean showTitleLevel;
    private final RawHtmlBuilder rootHtmlBuilder;
    private RawHtmlBuilder currentHtmlBuilder;
    private String titlePrefix;
    private int index;
    private int headerTagLevel;
    private Map<Integer, HtmlCanvas> indexChildMap;

    public HtmlCanvas(boolean showTitleLevel) {
        this(new RawHtmlBuilder("div"), showTitleLevel);
    }

    protected HtmlCanvas(RawHtmlBuilder rootHtmlBuilder, boolean showTitleLevel) {
        this.rootHtmlBuilder = rootHtmlBuilder;
        this.showTitleLevel = showTitleLevel;
        this.titlePrefix = "";
        this.index = 0;
        this.indexChildMap = new HashMap<Integer, HtmlCanvas>();
        this.headerTagLevel = 1;
        this.currentHtmlBuilder = rootHtmlBuilder;
    }

    @Override
    public void addSubtitle(String title) {
        String prefix = "";
        if (this.showTitleLevel) {
            if (this.index > 0) {
                prefix = this.titlePrefix + this.index + " ";
            }
            ++this.index;
        }
        if (this.headerTagLevel == 1) {
            this.addPageHeader(prefix, title);
            ++this.headerTagLevel;
        } else {
            RawHtmlBuilder header = this.createSubheaderTag(this.headerTagLevel);
            header.appendText(prefix);
            header.appendText((String)ObjectUtils.defaultIfNull((Object)title, (Object)""));
        }
    }

    protected RawHtmlBuilder createSubheaderTag(Integer headerTagLevel) {
        return this.currentHtmlBuilder.newChild("h" + headerTagLevel);
    }

    protected void addPageHeader(String prefix, String title) {
        RawHtmlBuilder header = this.currentHtmlBuilder.newChild("h1");
        header.appendText(prefix);
        header.appendText((String)ObjectUtils.defaultIfNull((Object)title, (Object)""));
    }

    @Override
    public DocumentCanvas addChild() {
        int titleIndex = this.index - 1;
        if (!this.indexChildMap.containsKey(titleIndex)) {
            HtmlCanvas newChild = this.newHtmlChildCanvas(this.currentHtmlBuilder.newChild("div"), this.showTitleLevel);
            if (this.showTitleLevel) {
                newChild.index = 1;
                newChild.headerTagLevel = this.childHeaderTagLevel();
                newChild.titlePrefix = this.titlePrefix + titleIndex + ".";
            }
            this.indexChildMap.put(titleIndex, newChild);
        }
        return this.indexChildMap.get(titleIndex);
    }

    @Nonnull
    protected HtmlCanvas newHtmlChildCanvas(RawHtmlBuilder child, boolean showTitleLevel) {
        return new HtmlCanvas(child, showTitleLevel);
    }

    private int childHeaderTagLevel() {
        int newHeaderTagLevel = this.headerTagLevel + 1;
        if (newHeaderTagLevel > 4) {
            return 4;
        }
        return newHeaderTagLevel;
    }

    @Override
    public void addFormItem(FormItem formItem) {
        RawHtmlBuilder span = this.currentHtmlBuilder.newChild("span");
        span.putAttribute("style", "margin-right:25px;");
        if (!StringUtils.isEmpty((CharSequence)formItem.getLabel())) {
            RawHtmlBuilder labelComp = span.newChild("label");
            labelComp.putAttribute("style", "font-weight:bold;");
            labelComp.appendText(formItem.getLabel());
            labelComp.appendText(": ");
        }
        span.appendText((String)ObjectUtils.defaultIfNull((Object)formItem.getValue(), (Object)""));
    }

    @Override
    public void addLineBreak() {
        this.currentHtmlBuilder.newChild("br");
    }

    @Override
    public void addList(List<String> values) {
        RawHtmlBuilder ul = this.currentHtmlBuilder.newChild("ul");
        for (String v : values) {
            RawHtmlBuilder li = ul.newChild("li");
            li.appendText(v);
        }
    }

    @Override
    public TableCanvas addTable() {
        this.addLineBreak();
        return new HtmlTableCanvas(this.getRootHtmlBuilder().newChild("table"));
    }

    public void stylesheet(String css) {
        RawHtmlBuilder style = this.currentHtmlBuilder.newChild("style");
        style.appendTextWithoutEscape(css);
    }

    public String build() {
        return this.rootHtmlBuilder.build();
    }

    protected RawHtmlBuilder getcurrentHtmlBuilder() {
        return this.currentHtmlBuilder;
    }

    public void setcurrentHtmlBuilder(RawHtmlBuilder currentHtmlBuilder) {
        this.currentHtmlBuilder = currentHtmlBuilder;
    }

    public RawHtmlBuilder getRootHtmlBuilder() {
        return this.rootHtmlBuilder;
    }
}

