/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.canvas.bootstrap;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.opensingular.lib.commons.canvas.FormItem;
import org.opensingular.lib.commons.canvas.HtmlCanvas;
import org.opensingular.lib.commons.canvas.builder.RawHtmlBuilder;
import org.opensingular.lib.commons.canvas.table.HtmlTableCanvas;
import org.opensingular.lib.commons.canvas.table.TableCanvas;

public class BootstrapHtmlCanvas
extends HtmlCanvas {
    public BootstrapHtmlCanvas(boolean showTitleLevel) {
        super(showTitleLevel);
        this.getRootHtmlBuilder().newChild("link").putAttribute("rel", "stylesheet").putAttribute("href", "http://localhost:8080/wkhtmltopdf-ws/resources/bootstrap/3.3.7/bootstrap.css").putAttribute("crossorigin", "anonymous");
        this.setcurrentHtmlBuilder(this.getRootHtmlBuilder().newChild("div").putAttribute("class", "container"));
    }

    public BootstrapHtmlCanvas(RawHtmlBuilder rawHtmlBuilder, boolean showTitleLevel) {
        super(rawHtmlBuilder, showTitleLevel);
    }

    @Override
    @Nonnull
    protected HtmlCanvas newHtmlChildCanvas(RawHtmlBuilder child, boolean showTitleLevel) {
        return new BootstrapHtmlCanvas(child, showTitleLevel);
    }

    @Override
    protected RawHtmlBuilder createSubheaderTag(Integer headerTagLevel) {
        return this.getcurrentHtmlBuilder().newChild("div").putAttribute("class", "col-md-12").newChild("h" + headerTagLevel);
    }

    @Override
    protected void addPageHeader(String prefix, String title) {
        this.getcurrentHtmlBuilder().newChild("div").putAttribute("class", "page-header text-center").newChild("h1").appendText((String)ObjectUtils.defaultIfNull((Object)title, (Object)""));
    }

    @Override
    public void addFormItem(FormItem formItem) {
        if (formItem.isValueAndLabelNull()) {
            return;
        }
        RawHtmlBuilder item = this.getcurrentHtmlBuilder().newChild("div");
        item.putAttribute("style", "word-wrap:break-word");
        if (formItem.getCols() != null) {
            item.appendAttribute("class", "col-md-" + formItem.getCols(), " ");
        }
        if (formItem.getLabel() != null) {
            item.newChild("strong").appendText(formItem.getLabel()).appendText(": ");
        }
        if (formItem.getValue() != null) {
            item.appendText(formItem.getValue());
        }
    }

    @Override
    public void addList(List<String> values) {
        RawHtmlBuilder ul = this.getcurrentHtmlBuilder().newChild("div").putAttribute("class", "col-md-12").newChild("ul").putAttribute("class", "list-unstyled");
        for (String v : values) {
            RawHtmlBuilder li = ul.newChild("li");
            li.appendText(v);
        }
    }

    @Override
    public void addLineBreak() {
        this.getcurrentHtmlBuilder().newChild("div").putAttribute("class", "col-md-12");
    }

    @Override
    public TableCanvas addTable() {
        return new HtmlTableCanvas(this.getRootHtmlBuilder().newChild("div").putAttribute("class", "col-md-12").newChild("table").putAttribute("class", "table"));
    }
}

