/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.canvas.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opensingular.lib.commons.canvas.builder.EscapedTextHtmlBuilder;
import org.opensingular.lib.commons.canvas.builder.HtmlBuilder;
import org.opensingular.lib.commons.canvas.builder.TextHtmlBuilder;

public class RawHtmlBuilder
implements HtmlBuilder {
    private final String tag;
    private List<HtmlBuilder> childs = new ArrayList<HtmlBuilder>();
    private Map<String, String> attribues = new LinkedHashMap<String, String>();
    private StringBuilder buffer = new StringBuilder();

    public RawHtmlBuilder(String tag) {
        this.tag = tag;
    }

    private void startTag() {
        this.buffer.append('<').append(this.tag);
        for (Map.Entry<String, String> attr : this.attribues.entrySet()) {
            this.buffer.append(' ');
            this.buffer.append(attr.getKey());
            this.buffer.append('=');
            this.buffer.append('\'').append(attr.getValue()).append('\'');
        }
        this.buffer.append('>');
    }

    private void endTag() {
        this.buffer.append("</").append(this.tag).append('>');
    }

    public RawHtmlBuilder newChild(String tag) {
        RawHtmlBuilder rawHtmlBuilder = new RawHtmlBuilder(tag);
        this.childs.add(rawHtmlBuilder);
        return rawHtmlBuilder;
    }

    public RawHtmlBuilder putAttribute(String key, String val) {
        this.attribues.put(key, val);
        return this;
    }

    public RawHtmlBuilder appendText(String text) {
        this.childs.add(new EscapedTextHtmlBuilder(text));
        return this;
    }

    @Override
    public String build() {
        this.startTag();
        for (HtmlBuilder builder : this.childs) {
            this.buffer.append(builder.build());
        }
        this.endTag();
        return this.buffer.toString();
    }

    public RawHtmlBuilder appendAttribute(String attr, String value, String separator) {
        if (!this.attribues.containsKey(attr)) {
            this.putAttribute(attr, value);
        } else {
            this.putAttribute(attr, this.attribues.get(attr) + separator + value);
        }
        return this;
    }

    public void appendTextWithoutEscape(String text) {
        this.childs.add(new TextHtmlBuilder(text));
    }
}

