/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.context;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opensingular.lib.commons.context.RefService;
import org.opensingular.lib.commons.context.ServiceRegistry;
import org.opensingular.lib.commons.context.SingularRegistryLookupException;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private final Map<ServiceKey, ServiceRegistry.ServiceEntry> services = Maps.newHashMap();

    @Override
    public Map<String, ServiceRegistry.ServiceEntry> services() {
        return this.services.entrySet().stream().collect(HashMap::new, (m, e) -> {
            ServiceRegistry.ServiceEntry cfr_ignored_0 = (ServiceRegistry.ServiceEntry)m.put(((ServiceKey)e.getKey()).getName(), e.getValue());
        }, HashMap::putAll);
    }

    @Override
    @Nonnull
    public <T> Optional<T> lookupService(@Nonnull Class<T> targetClass) {
        Optional<T> provider = this.lookupLocalService(targetClass);
        return provider;
    }

    @Nonnull
    public <T> Optional<T> lookupLocalService(@Nonnull Class<T> targetClass) {
        List<RefService<?>> result = this.findAllMatchingProviders(targetClass);
        if (result != null && !result.isEmpty()) {
            return this.verifyResultAndReturn(targetClass, result);
        }
        return Optional.empty();
    }

    private <T> List<RefService<?>> findAllMatchingProviders(Class<T> targetClass) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<ServiceKey, ServiceRegistry.ServiceEntry> entry : this.services.entrySet()) {
            if (!targetClass.isAssignableFrom(entry.getKey().serviceClass)) continue;
            result.add(entry.getValue().provider);
        }
        return result;
    }

    private <T> Optional<T> verifyResultAndReturn(Class<T> targetClass, List<RefService<?>> list) {
        if (list.size() == 1) {
            RefService<?> provider = list.get(0);
            return Optional.of(targetClass.cast(provider.get()));
        }
        String message = String.format("There are %s options of type %s please be more specific", list.size(), targetClass.getName());
        throw new SingularRegistryLookupException(message);
    }

    @Override
    @Nonnull
    public <T> Optional<T> lookupService(@Nonnull String name) {
        return this.lookupService(name, Object.class);
    }

    @Override
    public <T> Optional<T> lookupService(String name, Class<T> targetClass) {
        Optional<T> provider = this.lookupLocalService(name, targetClass);
        return provider;
    }

    public <T> Optional<T> lookupLocalService(@Nonnull String name, @Nonnull Class<T> targetClass) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(targetClass);
        ServiceRegistry.ServiceEntry ref = this.services.entrySet().stream().filter(k -> ((ServiceKey)k.getKey()).equals(new ServiceKey(name, targetClass))).findFirst().map(Map.Entry::getValue).orElse(null);
        if (ref != null) {
            Object value = ref.provider.get();
            return Optional.ofNullable(targetClass.cast(value));
        }
        return Optional.empty();
    }

    @Override
    public <T> void bindService(Class<T> registerClass, RefService<? extends T> provider) {
        this.bindService(registerClass.getName(), registerClass, provider);
    }

    @Override
    public <T> void bindService(@Nonnull String serviceName, Class<T> registerClass, RefService<? extends T> provider) {
        this.services.put(new ServiceKey(Objects.requireNonNull(serviceName), registerClass), new ServiceRegistry.ServiceEntry(registerClass, provider));
    }

    private static class ServiceKey {
        String name;
        Class<?> serviceClass;

        public ServiceKey(String name, Class<?> serviceClass) {
            this.name = name;
            this.serviceClass = serviceClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ServiceKey)) {
                return false;
            }
            ServiceKey that = (ServiceKey)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return that.serviceClass != null ? that.serviceClass.isAssignableFrom(this.serviceClass) : this.serviceClass == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.serviceClass != null ? this.serviceClass.hashCode() : 0);
            return result;
        }

        public String getName() {
            return Optional.ofNullable(this.name).orElse(this.serviceClass.getName());
        }
    }
}

