/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.context;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.opensingular.lib.commons.context.ServiceRefTransientValue;

public interface RefService<T>
extends Serializable,
Supplier<T> {
    @Override
    public T get();

    public static <T> RefService<T> cached(final RefService<T> supplier) {
        return new RefService<T>(){
            private transient T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
    }

    public static <T extends Serializable> RefService<T> of(T value) {
        return () -> value;
    }

    @Nonnull
    public static <T> ServiceRefTransientValue<T> ofToBeDescartedIfSerialized(@Nonnull T value) {
        return new ServiceRefTransientValue<T>(Objects.requireNonNull(value));
    }
}

