/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.context;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opensingular.internal.lib.commons.injection.SingularInjector;
import org.opensingular.lib.commons.context.RefService;
import org.opensingular.lib.commons.context.SingularBeanNotFoundException;

public interface ServiceRegistry {
    @Nonnull
    public <T> Optional<T> lookupService(@Nonnull Class<T> var1);

    @Nonnull
    default public <T> T lookupServiceOrException(@Nonnull Class<T> targetClass) {
        return this.lookupService(targetClass).orElseThrow(() -> new SingularBeanNotFoundException("Bean of class " + targetClass + " not found"));
    }

    @Nonnull
    public <T> Optional<T> lookupService(@Nonnull String var1, @Nonnull Class<T> var2);

    @Nonnull
    default public <T> T lookupServiceOrException(@Nonnull String name, @Nonnull Class<T> targetClass) {
        return this.lookupService(name, targetClass).orElseThrow(() -> new SingularBeanNotFoundException("Bean of class " + targetClass + " and name " + name + " not found"));
    }

    @Nonnull
    public <T> Optional<T> lookupService(@Nonnull String var1);

    @Nonnull
    default public <T> T lookupServiceOrException(@Nonnull String name) {
        return this.lookupService(name).orElseThrow(() -> new SingularBeanNotFoundException("Bean of name " + name + " not found"));
    }

    @Nonnull
    default public SingularInjector lookupSingularInjector() {
        Optional<SingularInjector> injector = this.lookupService(SingularInjector.class);
        if (injector.isPresent()) {
            return injector.get();
        }
        return SingularInjector.getEmptyInjector();
    }

    @Nonnull
    default public Optional<SingularInjector> lookupSingularInjectorOpt() {
        return this.lookupService(SingularInjector.class);
    }

    @Nonnull
    public Map<String, ServiceEntry> services();

    public <T> void bindService(Class<T> var1, RefService<? extends T> var2);

    public <T> void bindService(String var1, Class<T> var2, RefService<? extends T> var3);

    public static class ServiceEntry
    implements Serializable {
        public final Class<?> type;
        public final RefService<?> provider;

        public ServiceEntry(Class<?> type, RefService<?> provider) {
            this.type = type;
            this.provider = provider;
        }
    }
}

