/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.context;

import javax.annotation.Nonnull;
import org.opensingular.lib.commons.context.DelegationSingletonStrategy;
import org.opensingular.lib.commons.context.ResetEnabledSingularSingletonStrategy;
import org.opensingular.lib.commons.context.SingularContext;
import org.opensingular.lib.commons.context.SingularContextAlreadyConfiguredException;
import org.opensingular.lib.commons.context.SingularContextSetup;
import org.opensingular.lib.commons.context.SingularSingletonStrategy;
import org.opensingular.lib.commons.context.singleton.ThreadBoundedSingletonStrategy;

class SingularContextImpl
extends DelegationSingletonStrategy
implements SingularContext,
SingularContextSetup {
    private static SingularSingletonStrategy strategy;

    private SingularContextImpl() {
        this(new ThreadBoundedSingletonStrategy());
    }

    private SingularContextImpl(SingularSingletonStrategy strategy) {
        if (SingularContextImpl.strategy != null) {
            throw new SingularContextAlreadyConfiguredException();
        }
        SingularContextImpl.strategy = strategy;
        strategy.put(SingularContext.class, this);
    }

    static synchronized boolean isConfigured() {
        return strategy != null;
    }

    static synchronized SingularContext get() {
        if (!SingularContextImpl.isConfigured()) {
            SingularContextImpl.setup();
        }
        return strategy.get(SingularContext.class);
    }

    static synchronized void setup(SingularSingletonStrategy singularSingletonStrategy) {
        new SingularContextImpl(singularSingletonStrategy);
    }

    static synchronized void setup() {
        new SingularContextImpl();
    }

    static synchronized void reset() {
        SingularSingletonStrategy strategy2 = strategy;
        if (strategy2 instanceof ResetEnabledSingularSingletonStrategy) {
            ((ResetEnabledSingularSingletonStrategy)strategy2).reset();
        }
        strategy = null;
    }

    @Override
    @Nonnull
    protected SingularSingletonStrategy getStrategyImpl() {
        return strategy;
    }
}

