/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.context.singleton;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.opensingular.lib.commons.context.SingularSingletonNotFoundException;
import org.opensingular.lib.commons.context.SingularSingletonStrategy;

public class InstanceBoundedSingletonStrategy
implements SingularSingletonStrategy {
    private final Map<Object, Object> map = new HashMap<Object, Object>(0);

    @Override
    public synchronized <T> void put(@Nonnull T thisInstance) {
        if (thisInstance != null) {
            this.map.put(thisInstance.getClass(), thisInstance);
        }
    }

    @Override
    public synchronized <T> void put(Class<? super T> instanceClazz, T thisInstance) {
        if (thisInstance != null) {
            this.map.put(instanceClazz, thisInstance);
        }
    }

    @Override
    public synchronized <T> void put(String nameKey, T thisInstance) {
        if (thisInstance != null) {
            this.map.put(nameKey, thisInstance);
        }
    }

    @Override
    public synchronized <T> boolean exists(Class<T> classKey) {
        return this.map.containsKey(classKey);
    }

    @Override
    public synchronized boolean exists(String nameKey) {
        return this.map.containsKey(nameKey);
    }

    @Override
    public synchronized <T> T get(Class<T> singletonClass) throws SingularSingletonNotFoundException {
        Object value = this.map.get(singletonClass);
        if (value == null) {
            throw new SingularSingletonNotFoundException(singletonClass.getName());
        }
        return (T)value;
    }

    @Override
    public synchronized <T> T get(String name) throws SingularSingletonNotFoundException {
        Object value = this.map.get(name);
        if (value == null) {
            throw new SingularSingletonNotFoundException(name);
        }
        return (T)value;
    }

    @Override
    public synchronized <T> T singletonize(@Nonnull String nameKey, @Nonnull Supplier<T> singletonFactory) {
        return (T)this.map.computeIfAbsent(nameKey, k -> singletonFactory.get());
    }

    @Override
    public synchronized <T> T singletonize(@Nonnull Class<T> classKey, @Nonnull Supplier<T> singletonFactory) {
        Object v = this.map.computeIfAbsent(classKey, k -> singletonFactory.get());
        return classKey.cast(v);
    }

    @Override
    public synchronized Map<Object, Object> getEntries() {
        return this.map;
    }

    @Override
    public synchronized void putEntries(@Nonnull SingularSingletonStrategy source) {
        this.map.putAll(source.getEntries());
    }
}

