/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.context.SingularContext;
import org.opensingular.lib.commons.context.SingularSingletonStrategy;
import org.opensingular.lib.commons.extension.ExtensionQualifier;
import org.opensingular.lib.commons.extension.SingularExtension;
import org.opensingular.lib.commons.util.Loggable;

public final class SingularExtensionUtil
implements Loggable {
    private SingularExtensionUtil() {
    }

    public static SingularExtensionUtil get() {
        return ((SingularSingletonStrategy)((Object)SingularContext.get())).singletonize(SingularExtensionUtil.class, SingularExtensionUtil::new);
    }

    @Nonnull
    public <T extends SingularExtension> List<T> findExtensions(@Nonnull Class<T> extensionTarget) {
        return this.findExtensions(extensionTarget, null);
    }

    @Nonnull
    public <T extends SingularExtension> List<T> findExtensions(@Nonnull Class<T> extensionTarget, @Nullable String qualifier) {
        Objects.requireNonNull(extensionTarget);
        this.checkIfValidExtensionClass(extensionTarget);
        ArrayList<SingularExtension> list = new ArrayList<SingularExtension>();
        for (SingularExtension extension : this.loadServices(extensionTarget)) {
            if (qualifier != null && !this.hasQualifier(extension, qualifier)) continue;
            list.add(extension);
        }
        if (list.size() > 1) {
            list.sort((t1, t2) -> t2.getExtensionPriority() - t1.getExtensionPriority());
        }
        return list;
    }

    private <T extends SingularExtension> Iterable<T> loadServices(@Nonnull Class<T> extensionTarget) {
        try {
            return ServiceLoader.load(extensionTarget);
        }
        catch (ServiceConfigurationError e) {
            this.getLogger().debug(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private <T extends SingularExtension> boolean hasQualifier(@Nonnull T extension, @Nonnull String targetQualifier) {
        for (ExtensionQualifier q : (ExtensionQualifier[])extension.getClass().getAnnotationsByType(ExtensionQualifier.class)) {
            if (!Objects.equals(q.value(), targetQualifier)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public <T extends SingularExtension> Optional<T> findExtension(@Nonnull Class<T> extensionTarget) {
        return this.findExtension(extensionTarget, null);
    }

    @Nonnull
    public <T extends SingularExtension> Optional<T> findExtension(@Nonnull Class<T> extensionTarget, @Nullable String qualifier) {
        List<T> list = this.findExtensions(extensionTarget, qualifier);
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
    }

    @Nonnull
    public <T extends SingularExtension> T findExtensionOrException(@Nonnull Class<T> extensionTarget) {
        return this.findExtensionOrException(extensionTarget, null);
    }

    @Nonnull
    public <T extends SingularExtension> T findExtensionOrException(@Nonnull Class<T> extensionTarget, @Nullable String qualifier) {
        List<T> list = this.findExtensions(extensionTarget, qualifier);
        if (list.isEmpty()) {
            throw new SingularException("No registered implementation for " + extensionTarget.getName() + " was found");
        }
        return (T)((SingularExtension)list.get(0));
    }

    private <T extends SingularExtension> void checkIfValidExtensionClass(@Nonnull Class<T> extensionClass) {
        if (!extensionClass.getName().endsWith("Extension")) {
            throw new SingularException("The name of the class " + extensionClass.getName() + " is no valid for a extension point. It must ends with the sufix 'Extension'");
        }
    }
}

