/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.internal.function;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.lambda.ISupplier;

public final class SupplierUtil {
    private SupplierUtil() {
    }

    @Nonnull
    public static <T> Supplier<T> cached(@Nonnull Supplier<T> delegate) {
        return new SoftReferenceCacheSupplier<T>(delegate);
    }

    @Nonnull
    public static <T> ISupplier<T> serializable(@Nullable T value) {
        return new SerializableHolder<T>(value);
    }

    public static final class SerializableHolder<E>
    implements ISupplier<E> {
        private final Serializable content;

        SerializableHolder(@Nullable E content) {
            if (content != null && !(content instanceof Serializable)) {
                throw SingularException.rethrow("Objeto recebido n\u00e3o \u00e9 serializ\u00e1vel. Classe=" + content.getClass().getName() + ". Value=" + content);
            }
            this.content = (Serializable)content;
        }

        @Override
        @Nullable
        public E get() {
            return (E)this.content;
        }
    }

    private static final class SoftReferenceCacheSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> delegate;
        private SoftReference<T> reference;

        public SoftReferenceCacheSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized T get() {
            ObjectUtils.Null value = null;
            if (this.reference != null) {
                value = (ObjectUtils.Null)this.reference.get();
            }
            if (value == null) {
                if (this.delegate != null) {
                    value = (ObjectUtils.Null)this.delegate.get();
                }
                if (value == null) {
                    value = ObjectUtils.NULL;
                }
                this.reference = new SoftReference<ObjectUtils.Null>(value);
            }
            if (ObjectUtils.NULL.equals(value)) {
                return null;
            }
            return (T)value;
        }
    }
}

