/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.net;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.opensingular.lib.commons.base.SingularException;

public class Lnk
implements Serializable {
    private final boolean urlAppMissing;
    private final String url_;

    private Lnk(String url) {
        this.urlAppMissing = true;
        this.url_ = url;
    }

    public Lnk(String url, boolean urlAppMissing) {
        this.urlAppMissing = urlAppMissing;
        this.url_ = url;
    }

    private Lnk(String urlApp, String path) {
        if (urlApp == null) {
            this.urlAppMissing = true;
            this.url_ = path;
        } else {
            this.urlAppMissing = false;
            this.url_ = Lnk.concat(urlApp, path);
        }
    }

    public static Lnk of(String path) {
        return new Lnk(path);
    }

    public static Lnk of(String urlApp, String path) {
        return new Lnk(urlApp, path);
    }

    public static Lnk of(String urlApp, Lnk path) {
        return path.addUrlApp(urlApp);
    }

    public static String concat(String url, String path) {
        Objects.requireNonNull(url);
        Objects.requireNonNull(path);
        String s = url;
        s = s.length() > 0 && s.charAt(s.length() - 1) == '/' ? (path.length() > 0 && path.charAt(0) == '/' ? s.substring(0, s.length() - 1) + path : s + path) : (path.length() > 0 && path.charAt(0) == '/' ? s + path : s + "/" + path);
        return s;
    }

    public boolean isUrlAppMissing() {
        return this.urlAppMissing;
    }

    public Lnk addUrlApp(String urlApp) {
        if (urlApp == null || !this.urlAppMissing) {
            return this;
        }
        return new Lnk(Lnk.concat(urlApp, this.url_), false);
    }

    public Lnk appendPath(String path) {
        return new Lnk(Lnk.concat(this.url_, path), this.urlAppMissing);
    }

    public Lnk and(String parameter, Integer value) {
        if (value == null) {
            return this;
        }
        return this.and(parameter, value.toString());
    }

    public Lnk and(String parameter, String value) {
        if (value == null) {
            return this;
        }
        try {
            char separator = '&';
            if (this.url_.indexOf(63) == -1) {
                separator = '?';
            }
            return new Lnk(this.url_ + separator + parameter + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.name()), this.urlAppMissing);
        }
        catch (UnsupportedEncodingException e) {
            throw SingularException.rethrow(e);
        }
    }

    public Lnk addParamSeNaoPresente(String parameter, Object value) {
        if (value == null) {
            return this;
        }
        return this.addParamSeNaoPresente(parameter, value.toString());
    }

    public Lnk addParamSeNaoPresente(String parameter, String value) {
        if (value == null || this.url_.contains(parameter + "=")) {
            return this;
        }
        return this.and(parameter, value);
    }

    public String getHref() {
        return this.getHref("(ver)");
    }

    public String getHrefUrl() {
        return this.getHref(this.url_);
    }

    public String getHref(CharSequence text) {
        return "<a href=\"" + this.url_ + "\">" + text + "</a>";
    }

    public String getImg() {
        return "<img src=\"" + this.url_ + "\"/>";
    }

    public String getImg(String title) {
        return "<img src=\"" + this.url_ + "\" title=\"" + title + "\"/> ";
    }

    public String getHrefBlank(CharSequence text, CharSequence title) {
        return "<a target=\"_blank\" href=\"" + this.url_ + "\" title=\"" + title + "\">" + text + "</a>";
    }

    public String getHref(CharSequence text, CharSequence title) {
        return "<a href=\"" + this.url_ + "\" title=\"" + title + "\">" + text + "</a>";
    }

    public String toString() {
        return this.url_;
    }

    public String getUrl(String urlApp) {
        if (this.urlAppMissing) {
            Objects.requireNonNull(urlApp);
            return Lnk.concat(urlApp, this.url_);
        }
        return this.url_;
    }

    public String getUrl() {
        if (this.urlAppMissing) {
            throw new SingularException("UrlApp n\u00e3o definida para '" + this.url_ + "'");
        }
        return this.url_;
    }
}

