/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.pdf;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.opensingular.internal.lib.commons.util.TempFileProvider;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.pdf.PDFUtilUnix;
import org.opensingular.lib.commons.pdf.PDFUtilWin;
import org.opensingular.lib.commons.pdf.SingularPDFException;
import org.opensingular.lib.commons.util.Loggable;

public abstract class PDFUtil
implements Loggable {
    private static final String BEGIN_COMMAND = "/";
    private static final String SET_FONT = "Tf\n";
    private static final int SPACE = 32;
    public static final String SINGULAR_WKHTML2PDF_HOME = "singular.wkhtml2pdf.home";
    protected static String username = null;
    protected static String password = null;
    protected static String proxy = null;
    private static File wkhtml2pdfHome;
    private PageSize pageSize = null;
    private PageOrientation pageOrientation = null;
    private int javascriptDelay = 0;

    @Nonnull
    private static PDFUtil factory() {
        if (PDFUtil.isWindows()) {
            return new PDFUtilWin();
        }
        return new PDFUtilUnix();
    }

    public static final boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("win");
    }

    static final boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac os");
    }

    @Nonnull
    public static PDFUtil getInstance() {
        return PDFUtil.factory();
    }

    @Nonnull
    public File convertHTML2PDF(@Nonnull String html, @Nullable String header, @Nullable String footer) throws SingularPDFException {
        return this.convertHTML2PDF(html, header, footer, null);
    }

    @Nonnull
    public final File convertHTML2PDF(String rawHtml, @Nullable String rawHeader, @Nullable String rawFooter, @Nullable List<String> additionalConfig) throws SingularPDFException {
        try (TempFileProvider tmp = TempFileProvider.createForUseInTryClause(this);){
            File htmlFile = this.safeWrapHtmlToFile(rawHtml, tmp, "content.html");
            File headerFile = this.safeWrapHtmlToFile(rawHeader, tmp, "header.html");
            File footerFile = this.safeWrapHtmlToFile(rawFooter, tmp, "footer.html");
            File pdfFile = tmp.createTempFileByDontPutOnDeleteList("result.pdf");
            File file = this.convertHTML2PDF(htmlFile, headerFile, footerFile, additionalConfig, pdfFile);
            return file;
        }
    }

    @Nonnull
    public final File convertHTML2PDF(@Nonnull File htmlFile, @Nonnull File pdfFile) throws SingularPDFException {
        return this.convertHTML2PDF(htmlFile, null, null, null, pdfFile);
    }

    @Nonnull
    public final File convertHTML2PDF(@Nullable File htmlFile, @Nullable File headerFile, @Nullable File footerFile, @Nullable List<String> additionalConfig, @Nonnull File pdfFile) throws SingularPDFException {
        PDFUtil.getWkhtml2pdfHome();
        try (TempFileProvider tmp = TempFileProvider.createForUseInTryClause(this);){
            ArrayList<String> commandAndArgs = new ArrayList<String>(0);
            commandAndArgs.add(PDFUtil.getHomeAbsolutePath("bin", this.fixExecutableName("wkhtmltopdf")));
            if (!CollectionUtils.isEmpty(additionalConfig)) {
                commandAndArgs.addAll(additionalConfig);
                this.addSmartBreakScript(commandAndArgs);
            } else {
                this.addDefaultPDFCommandArgs(commandAndArgs);
            }
            if (headerFile != null) {
                commandAndArgs.add("--header-html");
                commandAndArgs.add(this.fixPathArg(headerFile));
                this.addDefaultHeaderCommandArgs(commandAndArgs);
            }
            if (footerFile != null) {
                commandAndArgs.add("--footer-html");
                commandAndArgs.add(this.fixPathArg(footerFile));
                this.addDefaultFooterCommandArgs(commandAndArgs);
            }
            commandAndArgs.add(this.fixPathArg(htmlFile));
            commandAndArgs.add(pdfFile.getAbsolutePath());
            File file = this.runProcess(commandAndArgs, pdfFile);
            return file;
        }
    }

    @Nonnull
    public final File convertHTML2PNG(@Nonnull String html, @Nullable List<String> additionalConfig) throws SingularPDFException {
        PDFUtil.getWkhtml2pdfHome();
        try (TempFileProvider tmp = TempFileProvider.createForUseInTryClause(this);){
            File htmlFile = tmp.createTempFile("content.html");
            this.writeToFile(htmlFile, html);
            ArrayList<String> commandAndArgs = new ArrayList<String>();
            commandAndArgs.add(PDFUtil.getHomeAbsolutePath("bin", this.fixExecutableName("wkhtmltoimage")));
            if (additionalConfig != null) {
                commandAndArgs.addAll(additionalConfig);
            } else {
                this.addDefaultPNGCommandArgs(commandAndArgs);
            }
            File pngFile = tmp.createTempFileByDontPutOnDeleteList("result.png");
            commandAndArgs.add(this.fixPathArg(htmlFile));
            commandAndArgs.add(pngFile.getAbsolutePath());
            File file = this.runProcess(commandAndArgs, pngFile);
            return file;
        }
    }

    @Nonnull
    public File convertHTML2PDF(@Nonnull String html) throws SingularPDFException {
        return this.convertHTML2PDF(html, null);
    }

    @Nonnull
    public File convertHTML2PNG(@Nonnull String html) throws SingularPDFException {
        return this.convertHTML2PNG(html, null);
    }

    @Nonnull
    public File convertHTML2PDF(@Nonnull String html, @Nullable String header) throws SingularPDFException {
        return this.convertHTML2PDF(html, header, null);
    }

    private void addDefaultPDFCommandArgs(List<String> commandArgs) {
        commandArgs.add("--print-media-type");
        commandArgs.add("--load-error-handling");
        commandArgs.add("ignore");
        if (this.pageSize != null) {
            commandArgs.add("--page-size");
            commandArgs.add(this.pageSize.getValue());
        }
        if (this.pageOrientation != null) {
            commandArgs.add("--orientation");
            commandArgs.add(this.pageOrientation.getValue());
        }
        if (this.javascriptDelay > 0) {
            commandArgs.add("--javascript-delay");
            commandArgs.add(String.valueOf(this.javascriptDelay));
        }
        this.addSmartBreakScript(commandArgs);
    }

    private void addSmartBreakScript(List<String> commandArgs) {
        String minificado = "\"!function(){function a(a){return'<span style=\\'page-break-inside: avoid\\'>'+a+'</span>'}function b(c,d){return c.length>d?a(c.substr(0,d))+b(c.substr(d,c.length),d):c}function c(a,b){if(0==a.children.length)b(a);else for(var d=0;d<a.children.length;d+=1)c(a.children[d],b)}c(document.getElementsByTagName('body')[0],function(a){a.innerHTML=b(a.innerHTML,600)})}();\"";
        commandArgs.add("--run-script");
        commandArgs.add("\"!function(){function a(a){return'<span style=\\'page-break-inside: avoid\\'>'+a+'</span>'}function b(c,d){return c.length>d?a(c.substr(0,d))+b(c.substr(d,c.length),d):c}function c(a,b){if(0==a.children.length)b(a);else for(var d=0;d<a.children.length;d+=1)c(a.children[d],b)}c(document.getElementsByTagName('body')[0],function(a){a.innerHTML=b(a.innerHTML,600)})}();\"");
    }

    private void addDefaultPNGCommandArgs(List<String> commandArgs) {
        commandArgs.add("--format");
        commandArgs.add("png");
        commandArgs.add("--load-error-handling");
        commandArgs.add("ignore");
        if (username != null) {
            commandArgs.add("--username");
            commandArgs.add(username);
        }
        if (password != null) {
            commandArgs.add("--password");
            commandArgs.add(password);
        }
        if (proxy != null) {
            commandArgs.add("--proxy");
            commandArgs.add(proxy);
        }
        if (this.javascriptDelay > 0) {
            commandArgs.add("--javascript-delay");
            commandArgs.add(String.valueOf(this.javascriptDelay));
        }
    }

    private void addDefaultHeaderCommandArgs(List<String> commandArgs) {
        commandArgs.add("--header-spacing");
        commandArgs.add("5");
    }

    private void addDefaultFooterCommandArgs(List<String> commandArgs) {
        commandArgs.add("--footer-spacing");
        commandArgs.add("5");
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageOrientation(PageOrientation pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    public void setJavascriptDelay(int javascriptDelay) {
        this.javascriptDelay = javascriptDelay;
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public File merge(@Nonnull List<InputStream> pdfs) throws SingularPDFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File safeWrapHtmlToFile(String rawHtml, TempFileProvider tmp, String name) {
        if (rawHtml == null) {
            return null;
        }
        File file = tmp.createTempFile(name);
        this.writeToFile(file, this.safeWrapHtml(rawHtml));
        return file;
    }

    private String safeWrapHtml(String html) {
        boolean needBody;
        if (html == null || html.startsWith("<!DOCTYPE")) {
            return html;
        }
        String wraped = html;
        boolean needHTML = !html.startsWith("<html>");
        boolean bl = needBody = needHTML && !html.startsWith("<body>");
        if (needBody) {
            wraped = "<body>" + wraped + "<body>";
        }
        if (needHTML) {
            wraped = "<!DOCTYPE HTML><html>" + wraped + "</html>";
        }
        return wraped;
    }

    @Nonnull
    protected static final File getWkhtml2pdfHome() {
        if (wkhtml2pdfHome == null) {
            Optional<String> prop = SingularProperties.get().getPropertyOpt(SINGULAR_WKHTML2PDF_HOME);
            if (!prop.isPresent()) {
                throw new SingularPDFException("property 'singular.wkhtml2pdf.home' not set");
            }
            File file = new File(prop.get());
            if (!file.exists()) {
                throw new SingularPDFException("property 'singular.wkhtml2pdf.home' configured for a directory that nos exists: " + file.getAbsolutePath());
            }
            wkhtml2pdfHome = file;
        }
        return wkhtml2pdfHome;
    }

    static final void clearHome() {
        wkhtml2pdfHome = null;
    }

    @Nonnull
    private static final String getHomeAbsolutePath(@Nullable String subDir, @Nonnull String file) throws SingularPDFException {
        File arq = PDFUtil.getWkhtml2pdfHome();
        arq = subDir == null ? new File(arq, file) : new File(arq, subDir + File.separator + file);
        if (!arq.exists()) {
            throw new SingularPDFException("Arquivo ou diret\u00f3rio '" + arq.getAbsolutePath() + "' n\u00e3o encontrado.");
        }
        return arq.getAbsolutePath();
    }

    protected String fixExecutableName(String executable) {
        return executable;
    }

    @Nonnull
    protected String fixPathArg(@Nullable File arq) {
        if (arq != null) {
            return arq.getAbsolutePath();
        }
        throw new SingularPDFException("Nenhum diretorio informado");
    }

    @Nonnull
    protected abstract File runProcess(@Nonnull List<String> var1, @Nonnull File var2) throws SingularPDFException;

    protected abstract void writeToFile(File var1, String var2) throws SingularPDFException;

    public static enum PageOrientation {
        PAGE_PORTRAIT("Portrait"),
        PAGE_LANDSCAPE("Landscape");

        private String value;

        private PageOrientation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PageSize {
        PAGE_A3("A3"),
        PAGE_A4("A4"),
        PAGE_LETTER("Letter");

        private String value;

        private PageSize(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

