/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.pdf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.pdf.PDFUtil;
import org.opensingular.lib.commons.pdf.SingularPDFException;

final class PDFUtilUnix
extends PDFUtil {
    PDFUtilUnix() {
    }

    @Override
    @Nonnull
    protected String fixPathArg(@Nullable File arq) {
        if (arq != null) {
            return "file://".concat(arq.getAbsolutePath());
        }
        throw new SingularPDFException("Nenhum arquivo informado");
    }

    @Override
    protected void writeToFile(File destination, String content) throws SingularPDFException {
        try (FileWriter fw = new FileWriter(destination);){
            fw.write(content);
        }
        catch (IOException e) {
            throw new SingularPDFException("Erro escrevendo conte\u00fado para arquivo " + destination.getAbsolutePath(), e);
        }
    }

    @Override
    @Nonnull
    protected File runProcess(@Nonnull List<String> commandAndArgs, @Nonnull File expectedFile) throws SingularPDFException {
        this.getLogger().info(commandAndArgs.toString());
        try {
            ProcessBuilder pb = new ProcessBuilder(commandAndArgs);
            pb.environment().put("LD_LIBRARY_PATH", PDFUtilUnix.getWkhtml2pdfHome().getAbsolutePath());
            Process process = pb.start();
            process.waitFor();
            return this.generateFile(process, expectedFile);
        }
        catch (IOException | InterruptedException e) {
            throw new SingularPDFException(e);
        }
    }

    private File generateFile(Process process, File expectedFile) throws SingularPDFException {
        boolean done = false;
        boolean success = true;
        try (BufferedReader outReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
             BufferedReader errReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String line = outReader.readLine();
            while (line != null) {
                this.getLogger().info(line);
                line = outReader.readLine();
            }
            line = errReader.readLine();
            while (line != null) {
                if (line.startsWith("Done")) {
                    done = true;
                } else if (line.startsWith("Warning:")) {
                    this.getLogger().warn(line);
                } else if (line.startsWith("Error:")) {
                    success = false;
                    this.getLogger().error(line);
                } else {
                    this.getLogger().info(line);
                }
                line = errReader.readLine();
            }
        }
        catch (IOException e) {
            throw new SingularPDFException(e);
        }
        if (done && success && expectedFile.exists()) {
            return expectedFile;
        }
        throw new SingularPDFException(String.format("O arquivo n\u00e3o foi gerado:  done:%b success:%b file.exists():%b", done, success, expectedFile.exists()));
    }
}

