/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.pdf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import org.opensingular.lib.commons.pdf.PDFUtil;
import org.opensingular.lib.commons.pdf.SingularPDFException;

final class PDFUtilWin
extends PDFUtil {
    PDFUtilWin() {
    }

    @Override
    protected String fixExecutableName(String executable) {
        return executable + ".exe";
    }

    @Override
    protected void writeToFile(File destination, String content) throws SingularPDFException {
        try (FileOutputStream fos = new FileOutputStream(destination);
             OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8.newEncoder());){
            fw.write(content);
        }
        catch (Exception e) {
            throw new SingularPDFException("Erro escrevendo conte\u00fado no arquivo" + destination.getAbsolutePath(), e);
        }
    }

    @Override
    @Nonnull
    protected File runProcess(@Nonnull List<String> commandAndArgs, @Nonnull File expectedFile) throws SingularPDFException {
        this.getLogger().info(commandAndArgs.toString());
        ProcessBuilder pb = new ProcessBuilder(commandAndArgs);
        pb.environment().put("LD_LIBRARY_PATH", PDFUtilWin.getWkhtml2pdfHome().getAbsolutePath());
        try {
            boolean success;
            Process process = pb.start();
            StreamGobbler outReader = new StreamGobbler(process.getInputStream(), false);
            StreamGobbler errReader = new StreamGobbler(process.getErrorStream(), true);
            outReader.start();
            errReader.start();
            boolean bl = success = process.waitFor() == 0;
            if (success && expectedFile.exists()) {
                return expectedFile;
            }
            throw new SingularPDFException("Arquivo n\u00e3o foi gerado " + expectedFile.getAbsolutePath());
        }
        catch (IOException | InterruptedException e) {
            throw new SingularPDFException(e);
        }
    }

    private class StreamGobbler
    extends Thread {
        private InputStream is;
        private boolean error;

        public StreamGobbler(InputStream is, boolean error) {
            this.is = is;
            this.error = error;
        }

        @Override
        public void run() {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.is));
                String line = reader.readLine();
                while (line != null) {
                    if (this.error) {
                        PDFUtilWin.this.getLogger().error(line);
                    } else {
                        PDFUtilWin.this.getLogger().info(line);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                PDFUtilWin.this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        PDFUtilWin.this.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

