/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.scan;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.context.SingularContext;
import org.opensingular.lib.commons.context.SingularSingletonStrategy;
import org.opensingular.lib.commons.util.Loggable;

public class SingularClassPathScanner
implements Loggable {
    private final ScanResult scanCache;

    protected SingularClassPathScanner() {
        long time = new Date().getTime();
        this.scanCache = new FastClasspathScanner(new String[0]).scan();
        this.getLogger().info("Full classpath scan in {} ms", (Object)(new Date().getTime() - time));
    }

    public static SingularClassPathScanner get() {
        return ((SingularSingletonStrategy)((Object)SingularContext.get())).singletonize(SingularClassPathScanner.class, SingularClassPathScanner::new);
    }

    public <T> Set<Class<? extends T>> findSubclassesOf(Class<T> clazz) {
        return this.convertClassesNamesToTypedClassesObjects(clazz, this.findClassesImplementingInterface(clazz), this.findSubclasses(clazz), this.findInterfacesExtendingInterface(clazz));
    }

    public <T> Set<Class<? extends T>> findSubclassesOf(Class<T> clazz, String ... filterPackages) {
        return this.convertClassesNamesToTypedClassesObjects(clazz, this.filterByPackages(this.findClassesImplementingInterface(clazz), Arrays.asList(filterPackages)), this.filterByPackages(this.findSubclasses(clazz), Arrays.asList(filterPackages)), this.filterByPackages(this.findInterfacesExtendingInterface(clazz), Arrays.asList(filterPackages)));
    }

    public Set<Class<?>> findClassesAnnotatedWith(Class<?> annotationClass) {
        if (!annotationClass.isAnnotation()) {
            throw SingularException.rethrow("Invalid Parameter: must be an annotation.");
        }
        return this.convertClassesNamesToTypedClassesObjects(Object.class, this.findAnnotated(annotationClass));
    }

    public Set<Class<?>> findClassesAnnotatedWith(Class<?> annotationClass, String ... filterPackages) {
        if (!annotationClass.isAnnotation()) {
            throw SingularException.rethrow("Invalid Parameter: must be an annotation.");
        }
        return this.convertClassesNamesToTypedClassesObjects(Object.class, this.filterByPackages(this.findAnnotated(annotationClass), Arrays.asList(filterPackages)));
    }

    private List<String> filterByPackages(List<String> classes, List<String> packages) {
        return classes.stream().filter(c -> packages.stream().anyMatch(c::startsWith)).collect(Collectors.toList());
    }

    private <T> Set<Class<? extends T>> convertClassesNamesToTypedClassesObjects(Class<T> type, List<String> ... lists) {
        HashSet result = new HashSet();
        for (List<String> list : lists) {
            list.forEach(className -> this.classLookup(type, (String)className).ifPresent(result::add));
        }
        return result;
    }

    private <T> Optional<Class<? extends T>> classLookup(Class<T> type, String className) {
        try {
            Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            return Optional.of(clazz.asSubclass(type));
        }
        catch (Throwable e) {
            this.getLogger().error(e.getMessage(), e);
            return Optional.empty();
        }
    }

    private List<String> findAnnotated(Class<?> clazz) {
        List result = Collections.emptyList();
        if (this.isAnnotation(clazz)) {
            result = this.scanCache.getNamesOfClassesWithAnnotation(clazz);
        }
        return result;
    }

    private List<String> findSubclasses(Class<?> clazz) {
        List result = Collections.emptyList();
        if (this.isNonFinalClass(clazz)) {
            result = this.scanCache.getNamesOfSubclassesOf(clazz);
        }
        return result;
    }

    private List<String> findClassesImplementingInterface(Class<?> clazz) {
        List result = Collections.emptyList();
        if (this.isInterface(clazz)) {
            result = this.scanCache.getNamesOfClassesImplementing(clazz);
        }
        return result;
    }

    private List<String> findInterfacesExtendingInterface(Class<?> clazz) {
        List result = Collections.emptyList();
        if (this.isInterface(clazz)) {
            result = this.scanCache.getNamesOfSubinterfacesOf(clazz);
        }
        return result;
    }

    private boolean isAnnotation(Class<?> clazz) {
        return clazz.isAnnotation();
    }

    private boolean isInterface(Class<?> clazz) {
        return clazz.isInterface();
    }

    private boolean isNonFinalClass(Class<?> clazz) {
        return !clazz.isAnnotation() && !clazz.isEnum() && !clazz.isInterface() && !Modifier.isFinal(clazz.getModifiers());
    }
}

