/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.opensingular.internal.lib.commons.xml.ConversorToolkit;
import org.opensingular.lib.commons.base.SingularException;

final class AlocproToolkit {
    private static final Pattern PATTERN_URL = Pattern.compile("(?i)\\b((?:https?://|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>]+|\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>???]))");

    private AlocproToolkit() {
    }

    public static String toHour(int minutes) {
        return AlocproToolkit.toHour(minutes, false);
    }

    public static String toHour(Integer min) {
        return AlocproToolkit.toHour(min, "");
    }

    public static String toHour(Integer min, String defaultValue) {
        if (min == null) {
            return defaultValue;
        }
        return AlocproToolkit.toHour((int)min, false);
    }

    public static String toHour(Number min, String defaultValue) {
        return AlocproToolkit.toHour(min, defaultValue, false);
    }

    public static String toHour(Number min, String defaultValue, boolean hoursWithTwoDigits) {
        if (min == null) {
            return defaultValue;
        }
        return AlocproToolkit.toHour(AlocproToolkit.round(min, 0).intValue(), hoursWithTwoDigits);
    }

    public static String toHour(Double minutes) {
        return AlocproToolkit.toHour(AlocproToolkit.round(minutes, 0).intValue(), false);
    }

    public static String toHour(int minutes, boolean hoursWithTwoDigits) {
        int h = minutes / 60;
        int m = minutes % 60;
        StringBuilder buffer = new StringBuilder(10);
        if (minutes < 0) {
            buffer.append('-');
            h = -minutes / 60;
            m = -minutes % 60;
        }
        if (hoursWithTwoDigits && h < 10) {
            buffer.append('0');
        }
        buffer.append(h).append(':');
        if (m < 10) {
            buffer.append('0');
        }
        buffer.append(m);
        return buffer.toString();
    }

    public static Number round(Number value, int decimals) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return AlocproToolkit.round((BigDecimal)value, decimals);
        }
        return AlocproToolkit.round(value.doubleValue(), decimals);
    }

    private static BigDecimal round(BigDecimal value, int decimals) {
        return value.round(new MathContext(decimals));
    }

    public static Double round(Double value, int decimals) {
        if (value == null) {
            return 0.0;
        }
        return AlocproToolkit.round((double)value, decimals);
    }

    public static long round(double value, int decimals) {
        long p = (long)Math.pow(10.0, decimals);
        return Math.round(value * (double)p) / p;
    }

    public static Double truncate(Double value, int decimals) {
        if (value == null) {
            return 0.0;
        }
        try {
            BigDecimal v = BigDecimal.valueOf(value);
            v = v.scaleByPowerOfTen(decimals).divideToIntegralValue(BigDecimal.ONE).scaleByPowerOfTen(-decimals);
            return v.doubleValue();
        }
        catch (Exception e) {
            throw SingularException.rethrow("Valor: " + value, e);
        }
    }

    public static Number add(Number a, Number b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.getClass() == b.getClass()) {
            if (a instanceof BigDecimal) {
                return ((BigDecimal)a).add((BigDecimal)b);
            }
            if (a instanceof Integer) {
                return a.intValue() + b.intValue();
            }
            if (a instanceof Long) {
                return a.longValue() + b.longValue();
            }
            if (a instanceof BigInteger) {
                return ((BigInteger)a).add((BigInteger)b);
            }
        }
        return AlocproToolkit.toBigDecimal(a).add(AlocproToolkit.toBigDecimal(b), MathContext.DECIMAL32);
    }

    public static Number multiply(Number a, Number b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.getClass() == b.getClass()) {
            if (a instanceof BigDecimal) {
                return ((BigDecimal)a).multiply((BigDecimal)b);
            }
            if (a instanceof Integer) {
                return a.intValue() * b.intValue();
            }
            if (a instanceof Long) {
                return a.longValue() * b.longValue();
            }
            if (a instanceof BigInteger) {
                return ((BigInteger)a).multiply((BigInteger)b);
            }
        }
        return AlocproToolkit.toBigDecimal(a).multiply(AlocproToolkit.toBigDecimal(b), MathContext.DECIMAL32);
    }

    public static Number divide(Number a, Number b) {
        if (a == null || b == null || AlocproToolkit.isZero(b)) {
            return null;
        }
        return AlocproToolkit.toBigDecimal(a).divide(AlocproToolkit.toBigDecimal(b), MathContext.DECIMAL32);
    }

    public static boolean isZero(Number a) {
        if (a instanceof BigDecimal) {
            return ((BigDecimal)a).compareTo(BigDecimal.ZERO) == 0;
        }
        if (AlocproToolkit.isIntegerOrLong(a)) {
            return a.longValue() == 0L;
        }
        return Double.doubleToRawLongBits(a.doubleValue()) == 0L;
    }

    private static BigDecimal toBigDecimal(Number a) {
        if (a instanceof BigDecimal) {
            return (BigDecimal)a;
        }
        if (a instanceof Double || a instanceof Float) {
            return BigDecimal.valueOf(a.doubleValue());
        }
        if (a instanceof Integer) {
            return BigDecimal.valueOf(a.intValue());
        }
        if (a instanceof BigInteger) {
            return new BigDecimal((BigInteger)a);
        }
        return BigDecimal.valueOf(a.longValue());
    }

    public static String plainTextToHtml(@Nullable String original, boolean converterURL) {
        if (original == null) {
            return null;
        }
        String cs = StringEscapeUtils.escapeHtml4((String)original);
        if (converterURL) {
            cs = AlocproToolkit.converterURL(cs);
        }
        return cs;
    }

    private static String converterURL(String original) {
        Matcher matcher = PATTERN_URL.matcher(original);
        if (matcher.find()) {
            if (matcher.group(1).startsWith("http://")) {
                return matcher.replaceAll("<a href=\"$1\">$1</a>");
            }
            return matcher.replaceAll("<a href=\"http://$1\">$1</a>");
        }
        return original;
    }

    @Nullable
    public static String printNumber(@Nullable Number value, int precision) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ConversorToolkit.printNumber((BigDecimal)value, (Integer)precision);
        }
        if (value instanceof Double) {
            return ConversorToolkit.printNumber((Double)value, precision);
        }
        if (AlocproToolkit.isIntegerOrLong(value)) {
            return ConversorToolkit.printNumber(value.longValue(), precision);
        }
        return ConversorToolkit.printNumber(value.doubleValue(), precision);
    }

    private static boolean isIntegerOrLong(Number value) {
        return value instanceof Integer || value instanceof Long;
    }
}

