/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.table.ColumnType;
import org.opensingular.lib.commons.table.ColumnTypeProcessor;
import org.opensingular.lib.commons.table.Decorator;
import org.opensingular.lib.commons.table.InfoCell;

public class Column
implements Serializable {
    private String id;
    private ColumnType type;
    private transient ColumnTypeProcessor processor;
    private int index;
    private String superTitle;
    private String title;
    private Alignment alignment;
    private String width;
    private boolean small;
    private boolean strong;
    private boolean visible = true;
    private Integer fractionDigits;
    private boolean showZero;
    private boolean showAsPercentageOfParent;
    private Number valueForPercentageCalculation;
    private boolean totalize = true;
    private Double total;
    private boolean hasSeparator;
    private int dataLevel = 0;
    private Decorator decoratorTitleAndValue = new Decorator();
    private Decorator decoratorTitle = this.decoratorTitleAndValue.newDerivedDecorator();
    private Decorator decoratorValues = this.decoratorTitleAndValue.newDerivedDecorator();

    public Column(@Nonnull ColumnType type) {
        this.setType(type);
    }

    public ColumnType getType() {
        return this.type;
    }

    @Nonnull
    public Decorator getDecoratorTitleAndValue() {
        return this.decoratorTitleAndValue;
    }

    @Nonnull
    public Decorator getDecoratorTitle() {
        return this.decoratorTitle;
    }

    @Nonnull
    public Decorator getDecoratorValues() {
        return this.decoratorValues;
    }

    public boolean isTotalize() {
        return this.totalize;
    }

    public Column setTotalize(boolean totalize) {
        this.totalize = totalize;
        return this;
    }

    public void addTotal(Number number) {
        Number n = number;
        if (number == null) {
            n = 0.0;
        }
        this.total = this.total == null ? Double.valueOf(n.doubleValue()) : Double.valueOf(this.total + n.doubleValue());
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public Double getTotal() {
        return this.total;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Column setAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public boolean hasSeparator() {
        return this.hasSeparator;
    }

    public Column setHasSeparator(boolean hasSeparator) {
        this.hasSeparator = hasSeparator;
        return this;
    }

    public Column setAlignmentLeft() {
        this.alignment = Alignment.LEFT;
        return this;
    }

    public Column setAlignmentCenter() {
        this.alignment = Alignment.CENTER;
        return this;
    }

    public Column setAlignmentRight() {
        this.alignment = Alignment.RIGHT;
        return this;
    }

    public Column setWidth(String w) {
        this.width = w;
        return this;
    }

    public String getWidth() {
        return this.width;
    }

    public Column setSmall(boolean v) {
        this.small = v;
        return this;
    }

    public boolean isSmall() {
        return this.small;
    }

    public Column setStrong(boolean strong) {
        this.strong = strong;
        return this;
    }

    public boolean isStrong() {
        return this.strong;
    }

    public Column setFractionDigits(Integer qtd) {
        this.fractionDigits = qtd;
        return this;
    }

    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    int getFractionDigits(int defaultNumberOfDigits) {
        return this.fractionDigits != null ? this.fractionDigits : defaultNumberOfDigits;
    }

    public Alignment getAlignment() {
        if (this.alignment != null) {
            return this.alignment;
        }
        return this.getProcessor().getDefaultAlignment();
    }

    public boolean isTypeAction() {
        return ColumnType.ACTION == this.type;
    }

    public void setSuperTitle(String superTitle) {
        this.superTitle = superTitle;
    }

    public String getSuperTitle() {
        return this.superTitle;
    }

    public Column setVisible(boolean v) {
        this.visible = v;
        return this;
    }

    public String getId() {
        return this.id != null ? this.id : "c" + this.getIndex();
    }

    public Column setId(String id) {
        this.id = id;
        return this;
    }

    public final boolean isShowAsPercentageOfParent() {
        return this.showAsPercentageOfParent;
    }

    public final Column setShowAsPercentageOfParent(boolean showAsPercentageOfParent) {
        this.showAsPercentageOfParent = showAsPercentageOfParent;
        return this;
    }

    final Number getValueForPercentageCalculation() {
        return this.valueForPercentageCalculation;
    }

    final void setValueForPercentageCalculation(Number valueForPercentageCalculation) {
        this.valueForPercentageCalculation = valueForPercentageCalculation;
    }

    public void setType(@Nonnull ColumnType type) {
        this.type = type;
        this.processor = type.getProcessor();
    }

    @Nonnull
    public ColumnTypeProcessor getProcessor() {
        if (this.processor == null) {
            throw new SingularException("Processador da coluna est\u00e1 null");
        }
        return this.processor;
    }

    public Column setShowZero() {
        this.showZero = true;
        return this;
    }

    public boolean isShowZero() {
        return this.showZero;
    }

    public void setDataLevel(int value) {
        this.dataLevel = value;
    }

    public final int getDataLevel() {
        return this.dataLevel;
    }

    public final int getIndex() {
        return this.index;
    }

    final void setIndex(int index) {
        this.index = index;
    }

    public int compare(InfoCell infoCell1, InfoCell infoCell2) {
        Object v2;
        Object v1 = this.normalizeToNull(infoCell1);
        if (v1 == (v2 = this.normalizeToNull(infoCell2))) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return this.getProcessor().compare(v1, v2);
    }

    private Object normalizeToNull(InfoCell c) {
        return c == null ? null : (c.getValueReal() != null ? c.getValueReal() : c.getValue());
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

