/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public enum ColumnAggregationType {
    CALCULATION("Calcular"){

        @Override
        public boolean isApplicable(Class<?> dataClass) {
            return true;
        }

        @Override
        public Object calculate(List<?> data) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    MIN("M\u00ednimo"){

        @Override
        public boolean isApplicable(Class<?> dataClass) {
            return Comparable.class.isAssignableFrom(dataClass);
        }

        @Override
        public Object calculate(List<?> data) {
            return data.stream().filter(Predicates.instanceOf(Comparable.class)).map(Comparable.class::cast).min(Comparator.comparing(Function.identity())).orElse(null);
        }
    }
    ,
    MAX("M\u00e1ximo"){

        @Override
        public boolean isApplicable(Class<?> dataClass) {
            return Comparable.class.isAssignableFrom(dataClass);
        }

        @Override
        public Object calculate(List<?> data) {
            return data.stream().filter(Predicates.instanceOf(Comparable.class)).map(Comparable.class::cast).max(Comparator.comparing(Function.identity())).orElse(null);
        }
    }
    ,
    MEDIA("M\u00e9dia"){

        @Override
        public boolean isApplicable(Class<?> dataClass) {
            return Long.class.isAssignableFrom(dataClass) || Integer.class.isAssignableFrom(dataClass) || Double.class.isAssignableFrom(dataClass);
        }

        @Override
        public Object calculate(List<?> data) {
            if (data.stream().anyMatch(Predicates.instanceOf(Double.class))) {
                return data.stream().map(info -> info == null ? Double.valueOf(0.0) : info).filter((Predicate<Object>)Predicates.instanceOf(Double.class)).mapToDouble(Double.class::cast).average().orElse(0.0);
            }
            if (data.stream().anyMatch(Predicates.instanceOf(Integer.class))) {
                return data.stream().map(info -> info == null ? Integer.valueOf(0) : info).filter((Predicate<Object>)Predicates.instanceOf(Integer.class)).mapToInt(Integer.class::cast).average().orElse(0.0);
            }
            if (data.stream().anyMatch(Predicates.instanceOf(Long.class))) {
                return data.stream().map(info -> info == null ? Long.valueOf(0L) : info).filter((Predicate<Object>)Predicates.instanceOf(Long.class)).mapToLong(Long.class::cast).average().orElse(0.0);
            }
            return 0;
        }
    }
    ,
    SUM("Soma"){

        @Override
        public boolean isApplicable(Class<?> dataClass) {
            return Long.class.isAssignableFrom(dataClass) || Integer.class.isAssignableFrom(dataClass) || Double.class.isAssignableFrom(dataClass);
        }

        @Override
        public Object calculate(List<?> data) {
            if (data.stream().anyMatch(Predicates.instanceOf(Collection.class))) {
                return data.stream().filter(Predicates.instanceOf(Collection.class)).map(Collection.class::cast).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            }
            if (data.stream().anyMatch(Predicates.instanceOf(Double.class))) {
                return data.stream().filter(Predicates.instanceOf(Double.class)).mapToDouble(Double.class::cast).sum();
            }
            if (data.stream().anyMatch(Predicates.instanceOf(Integer.class))) {
                return data.stream().filter(Predicates.instanceOf(Integer.class)).mapToInt(Integer.class::cast).sum();
            }
            if (data.stream().anyMatch(Predicates.instanceOf(Long.class))) {
                return data.stream().filter(Predicates.instanceOf(Long.class)).mapToLong(Long.class::cast).sum();
            }
            if (data.stream().anyMatch(Predicates.instanceOf(String.class))) {
                return data.stream().filter(Predicates.instanceOf(String.class)).map(String.class::cast).distinct().collect(Collectors.joining("; "));
            }
            return null;
        }
    }
    ,
    COUNT("Qtd."){

        @Override
        public boolean isApplicable(Class<?> dataClass) {
            return true;
        }

        @Override
        public Object calculate(List<?> data) {
            return data.stream().filter(Objects::nonNull).count();
        }
    }
    ,
    COUNT_DISTINCT("Qtd. \u00danica"){

        @Override
        public boolean isApplicable(Class<?> dataClass) {
            return true;
        }

        @Override
        public Object calculate(List<?> data) {
            return data.stream().filter(Objects::nonNull).distinct().count();
        }
    };

    private final String name;

    private ColumnAggregationType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCalculation() {
        return this == CALCULATION;
    }

    public boolean isSum() {
        return this == SUM;
    }

    public boolean isCount() {
        return this == COUNT;
    }

    public boolean isCountDistinct() {
        return this == COUNT_DISTINCT;
    }

    public boolean isApplicable(Class<?> dataClass) {
        return true;
    }

    public Object calculate(Supplier<List<?>> valueListSupplier) {
        return this.calculate(valueListSupplier.get());
    }

    public abstract Object calculate(List<?> var1);
}

