/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.base.AbstractInstant;
import org.opensingular.internal.lib.commons.xml.ConversorToolkit;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.table.AlocproToolkit;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.InfoCell;

public interface ColumnTypeProcessor {
    public static final ColumnTypeProcessor BOOLEAN = new ColumnTypeProcessorTypeBoolean();
    public static final ColumnTypeProcessor ACTION = new ColumnTypeProcessorTypeAction();
    public static final ColumnTypeProcessor DATE = new ColumnTypeProcessorTypeDateBased("short");
    public static final ColumnTypeProcessor DATE_HOUR = new ColumnTypeProcessorTypeDateBased("dd/MM/yy HH:mm:ss");
    public static final ColumnTypeProcessor DATE_HOUR_SHORT = new ColumnTypeProcessorTypeDateBased("dd/MM/yy HH:mm");
    public static final ColumnTypeProcessor DAY = new ColumnTypeProcessorTypeDateBased("dd");
    public static final ColumnTypeProcessor RAW = new ColumnTypeProcessorTypeRaw();
    public static final ColumnTypeProcessor STRING = new ColumnTypeProcessorTypeString();
    public static final ColumnTypeProcessor NUMBER = new ColumnTypeProcessorTypeNumber();
    public static final ColumnTypeProcessor INTEGER = new ColumnTypeProcessorTypeInteger();
    public static final ColumnTypeProcessor PERCENT = new ColumnTypeProcessorTypePercent();
    public static final ColumnTypeProcessor HOUR = new ColumnTypeProcessorTypeHour();

    default public boolean isNullContent(InfoCell cell) {
        return cell == null || cell.getValue() == null;
    }

    default public boolean shouldBePrinted() {
        return true;
    }

    default public boolean shouldBeGeneretedOnStaticContent() {
        return true;
    }

    default public PrintResult generatePrintValue(@Nonnull Column column, @Nullable Object value) {
        PrintResult result = new PrintResult();
        this.generatePrintValue(result, column, value);
        return result;
    }

    public void generatePrintValue(@Nonnull PrintResult var1, @Nonnull Column var2, @Nullable Object var3);

    default public Column.Alignment getDefaultAlignment() {
        return Column.Alignment.LEFT;
    }

    default public int compare(@Nonnull Object v1, @Nonnull Object v2) {
        if (v1 instanceof Comparable && v1.getClass().isAssignableFrom(v2.getClass())) {
            return ((Comparable)v1).compareTo(v2);
        }
        throw new SingularException("It's not possible to compare the object of the class " + v1.getClass().getName() + " and " + v2.getClass().getName());
    }

    public static class ColumnTypeProcessorTypeHour
    extends ColumnTypeProcessorTypeNumber {
        @Override
        protected void generatePrintValue(@Nonnull PrintResult result, @Nonnull Column column, @Nonnull Number value) {
            result.setContent(AlocproToolkit.toHour(value, null));
        }
    }

    public static class ColumnTypeProcessorTypePercent
    extends ColumnTypeProcessorTypeNumber {
        public ColumnTypeProcessorTypePercent() {
            super(1);
        }

        @Override
        protected void generatePrintValue(@Nonnull PrintResult result, @Nonnull Column column, @Nonnull Number value) {
            Number n = AlocproToolkit.multiply(value, 100);
            result.setContent(this.format(column, n) + "%");
        }
    }

    public static class ColumnTypeProcessorTypeInteger
    extends ColumnTypeProcessorTypeNumber {
        public ColumnTypeProcessorTypeInteger() {
            super(0);
        }
    }

    public static class ColumnTypeProcessorTypeNumber
    implements ColumnTypeProcessor {
        private final int defaultNumberOfDigits;

        ColumnTypeProcessorTypeNumber() {
            this(2);
        }

        ColumnTypeProcessorTypeNumber(int defaultNumberOfDigits) {
            this.defaultNumberOfDigits = defaultNumberOfDigits;
        }

        @Override
        public boolean isNullContent(InfoCell cell) {
            if (cell == null || cell.getValue() == null) {
                return true;
            }
            if (cell.getValue() instanceof Number) {
                return !cell.getColumn().isShowZero() && AlocproToolkit.isZero((Number)cell.getValue());
            }
            return false;
        }

        @Override
        public final void generatePrintValue(PrintResult result, Column column, Object value) {
            if (value instanceof Number) {
                Number n = (Number)value;
                if (!column.isShowZero() && AlocproToolkit.isZero(n)) {
                    result.setContent(null);
                } else {
                    this.generatePrintValue(result, column, n);
                }
            }
        }

        protected void generatePrintValue(@Nonnull PrintResult result, @Nonnull Column column, @Nonnull Number value) {
            result.setContent(this.format(column, value));
        }

        protected String format(Column column, Number value) {
            return AlocproToolkit.printNumber(value, column.getFractionDigits(this.defaultNumberOfDigits));
        }

        @Override
        public Column.Alignment getDefaultAlignment() {
            return Column.Alignment.RIGHT;
        }

        @Override
        public int compare(@Nonnull Object v1, @Nonnull Object v2) {
            if (v1 instanceof Integer && v2 instanceof Integer) {
                return Integer.compare((Integer)v1, (Integer)v2);
            }
            if (v1 instanceof Number && v2 instanceof Number) {
                return Double.compare(((Number)v1).doubleValue(), ((Number)v2).doubleValue());
            }
            throw new SingularException("It's not possible to compare the object of the class " + v1.getClass().getName() + " and " + v2.getClass().getName());
        }
    }

    public static class ColumnTypeProcessorTypeString
    implements ColumnTypeProcessor {
        @Override
        public void generatePrintValue(PrintResult result, Column column, Object value) {
        }

        @Override
        public int compare(@Nonnull Object v1, @Nonnull Object v2) {
            return Objects.toString(v1).compareToIgnoreCase(Objects.toString(v2));
        }
    }

    public static class ColumnTypeProcessorTypeRaw
    implements ColumnTypeProcessor {
        @Override
        public void generatePrintValue(PrintResult result, Column column, Object value) {
            result.setContent(value == null ? null : value.toString());
        }

        @Override
        public int compare(@Nonnull Object v1, @Nonnull Object v2) {
            return Objects.toString(v1).compareToIgnoreCase(Objects.toString(v2));
        }
    }

    public static class ColumnTypeProcessorTypeDateBased
    implements ColumnTypeProcessor {
        private final String dateFormat;

        public ColumnTypeProcessorTypeDateBased(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void generatePrintValue(PrintResult result, Column column, Object value) {
            Date date = this.asDate(value);
            if (date != null) {
                result.setContent(ConversorToolkit.printDate(date, this.dateFormat));
            }
        }

        private Date asDate(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof LocalDate) {
                return ((LocalDate)value).toDate();
            }
            if (value instanceof LocalDateTime) {
                return ((LocalDateTime)value).toDate();
            }
            if (value instanceof AbstractInstant) {
                return ((AbstractInstant)value).toDate();
            }
            return null;
        }

        @Override
        public Column.Alignment getDefaultAlignment() {
            return Column.Alignment.CENTER;
        }

        @Override
        public int compare(@Nonnull Object v1, @Nonnull Object v2) {
            Date d2;
            Date d1 = this.asDate(v1);
            if (d1 == (d2 = this.asDate(v2))) {
                return 0;
            }
            if (d1 == null) {
                return -1;
            }
            if (d2 == null) {
                return 1;
            }
            return d1.compareTo(d2);
        }
    }

    public static class ColumnTypeProcessorTypeBoolean
    implements ColumnTypeProcessor {
        @Override
        public void generatePrintValue(PrintResult result, Column column, Object value) {
            if (value instanceof Boolean) {
                result.setContent((Boolean)value != false ? "Sim" : "N\u00e3o");
            }
        }

        @Override
        public Column.Alignment getDefaultAlignment() {
            return Column.Alignment.CENTER;
        }

        @Override
        public int compare(@Nonnull Object v1, @Nonnull Object v2) {
            if (v1 instanceof Boolean && v2 instanceof Boolean) {
                return Boolean.compare((Boolean)v1, (Boolean)v2);
            }
            throw new SingularException("It's not possible to compare the object of the class " + v1.getClass().getName() + " and " + v2.getClass().getName());
        }
    }

    public static class ColumnTypeProcessorTypeAction
    implements ColumnTypeProcessor {
        @Override
        public boolean isNullContent(InfoCell cell) {
            return cell == null || cell.isActionsEmpty();
        }

        @Override
        public boolean shouldBePrinted() {
            return false;
        }

        @Override
        public boolean shouldBeGeneretedOnStaticContent() {
            return false;
        }

        @Override
        public void generatePrintValue(PrintResult result, Column column, Object value) {
            throw new SingularException("This method shouldn't be called");
        }
    }

    public static class PrintResult {
        private String content;
        private boolean defined;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
            this.defined = true;
        }

        public boolean isDefined() {
            return this.defined;
        }
    }
}

