/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.table.DataReader;
import org.opensingular.lib.commons.table.GeneratorUtil;
import org.opensingular.lib.commons.table.LineData;
import org.opensingular.lib.commons.table.LineInfo;
import org.opensingular.lib.commons.table.LineReadContext;
import org.opensingular.lib.commons.table.TableTool;
import org.opensingular.lib.commons.table.TreeLineReader;

final class DataReaderByIterator
extends DataReader {
    private final TreeLineReader reader;
    private final int numLevel;
    private boolean empty = true;
    private boolean read;
    private Iterator<?> original;
    private LineData current;
    private List<LineData> dataLines;

    public DataReaderByIterator(TreeLineReader reader, Object list, int numLevel) {
        this.reader = reader;
        this.numLevel = numLevel;
        if (list != null) {
            this.original = GeneratorUtil.obterIterador(list);
            this.next();
            this.empty = this.current == null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    private void next() {
        if (this.original == null) {
            throw new SingularException("No existe nada para ler");
        }
        while (this.original.hasNext()) {
            Object v = this.original.next();
            if (v == null) continue;
            this.current = new LineData(this, v);
            return;
        }
        this.current = null;
        this.original = null;
    }

    @Override
    public Iterator<LineData> iterator() {
        if (this.dataLines != null) {
            return this.dataLines.iterator();
        }
        if (this.read) {
            throw new SingularException("No pode ser chamado iterator() duas vezes");
        }
        this.read = true;
        return new Iterator<LineData>(){

            @Override
            public boolean hasNext() {
                return DataReaderByIterator.this.current != null;
            }

            @Override
            public LineData next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                LineData next = DataReaderByIterator.this.current;
                DataReaderByIterator.this.next();
                return next;
            }
        };
    }

    @Override
    public List<LineData> preLoadData() {
        if (this.dataLines == null) {
            this.dataLines = this.isEmpty() ? new ArrayList<LineData>(1) : Lists.newArrayList((Iterable)this);
        }
        return this.dataLines;
    }

    @Override
    public DataReaderByIterator getChildren(LineData lineData) {
        return new DataReaderByIterator(this.reader, this.reader.getChildren(lineData.getValue()), this.numLevel + 1);
    }

    @Override
    public LineInfo retrieveValues(LineReadContext ctx, LineData lineData) {
        LineInfo line = ctx.getTable().newBlankLine();
        this.reader.retrieveValues(ctx, lineData.getValue(), line);
        return line;
    }

    @Override
    public List<LineData> preLoadDataAndCells(TableTool tableTool) {
        List<LineData> list = this.preLoadData();
        LineReadContext ctx = new LineReadContext(tableTool);
        ctx.setLevel(this.numLevel);
        for (LineData data : list) {
            data.retrieveValues(ctx, this.numLevel, true, true);
        }
        return list;
    }
}

