/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Decorator
implements Serializable {
    private final Decorator parent;
    private String cssClass;
    private Map<String, String> attributes;
    private Map<String, String> styles;
    private Integer maxTextLength;

    public Decorator() {
        this.parent = null;
    }

    public Decorator(Decorator parent) {
        this.parent = parent;
    }

    public Decorator newDerivedDecorator() {
        return new Decorator(this);
    }

    @Nonnull
    public Decorator setFontColor(@Nullable String cor) {
        return this.addStyle("color", cor);
    }

    @Nonnull
    public Decorator setBackground(@Nullable String cor) {
        return this.addStyle("background-color", cor);
    }

    public Decorator setNoWrap() {
        return this.addStyle("white-space", "nowrap");
    }

    @Nonnull
    public Decorator setCssClass(@Nullable String cssClass) {
        this.cssClass = cssClass;
        return this;
    }

    @Nullable
    public String getCssClass() {
        return this.cssClass != null ? this.cssClass : (this.parent == null ? null : this.parent.getCssClass());
    }

    public Integer getMaxTextLength() {
        return this.maxTextLength != null ? this.maxTextLength : (this.parent == null ? null : this.parent.getMaxTextLength());
    }

    @Nonnull
    public final Decorator setBold(boolean bold) {
        return this.addStyle("font-weight", bold ? "bold" : "inherit");
    }

    @Nonnull
    public Decorator addStyle(@Nonnull String name, @Nullable String value) {
        Objects.requireNonNull(name);
        if (this.styles == null) {
            this.styles = new HashMap<String, String>();
        }
        if (value == null) {
            this.styles.remove(value);
        } else {
            this.styles.put(name, value);
        }
        return this;
    }

    @Nonnull
    public Decorator addTitle(@Nullable String value) {
        return this.addAttribute("title", value);
    }

    @Nonnull
    public Decorator addAttribute(@Nonnull String name, @Nullable String value) {
        Objects.requireNonNull(name);
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    public boolean containsAttribute(@Nonnull String attributeName) {
        return this.attributes != null && this.attributes.containsKey(Objects.requireNonNull(attributeName)) || this.parent != null && this.parent.containsAttribute(attributeName);
    }

    @Nonnull
    public Map<String, String> getAttributes() {
        return Decorator.mergeMaps(this, d -> d.attributes);
    }

    @Nonnull
    public Map<String, String> getStyles() {
        return Decorator.mergeMaps(this, d -> this.styles);
    }

    @Nonnull
    private static Map<String, String> mergeMaps(Decorator decorator, Function<Decorator, Map<String, String>> reader) {
        Map<String, String> result = reader.apply(decorator);
        if (decorator.parent != null) {
            if (result == null) {
                return Decorator.mergeMaps(decorator.parent, reader);
            }
            Map<String, String> merged = Decorator.createNewMapForMerge(decorator.parent, reader);
            if (merged != null) {
                merged.putAll(result);
                return merged;
            }
        }
        return result == null ? Collections.emptyMap() : result;
    }

    private static Map<String, String> createNewMapForMerge(Decorator decorator, Function<Decorator, Map<String, String>> reader) {
        if (decorator == null) {
            return null;
        }
        Map<String, String> resultParent = Decorator.createNewMapForMerge(decorator.parent, reader);
        Map<String, String> resultCurrent = reader.apply(decorator);
        if (resultParent == null) {
            if (resultCurrent != null) {
                return new LinkedHashMap<String, String>(resultCurrent);
            }
        } else if (resultCurrent != null) {
            resultParent.putAll(resultCurrent);
        }
        return resultParent;
    }
}

