/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opensingular.internal.lib.commons.xml.ConversorToolkit;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.ColumnAggregationType;
import org.opensingular.lib.commons.table.DataReader;
import org.opensingular.lib.commons.table.DataReaderFixed;
import org.opensingular.lib.commons.table.GenerationModifier;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineData;
import org.opensingular.lib.commons.table.TableTool;

public class GenerationModifierAggregate
extends GenerationModifier {
    private final HashMap<Column, ColumnAggregationType> aggregationTypeByColumn = new HashMap();
    private final HashMap<Column, Object> externalResultByColumn = new HashMap();

    GenerationModifierAggregate(TableTool tableTool) {
        super(tableTool);
    }

    void addColumn(Column column, ColumnAggregationType aggregationType) {
        this.aggregationTypeByColumn.put(column, aggregationType);
    }

    void setColumnExternalResult(Column column, Object value) {
        this.externalResultByColumn.put(column, value);
    }

    @Override
    public DataReader apply(DataReader original) {
        List<LineData> lines = original.preLoadDataAndCells(this.getTable());
        LineData aggregator = new LineData(this.getTable().newBlankLine());
        if (!this.aggregationTypeByColumn.containsKey(this.getColumns().get(0))) {
            aggregator.getInfoCell(this.getColumns().get(0)).setValue("Resultado").getDecorator().addTitle("Agregado").setBold(true);
        }
        this.doAggregation(lines, aggregator);
        lines.add(aggregator);
        return super.apply(new DataReaderFixed(original, lines));
    }

    void doAggregation(Collection<LineData> lines, LineData aggregator) {
        for (Map.Entry<Column, ColumnAggregationType> entry : this.aggregationTypeByColumn.entrySet()) {
            ColumnAggregationType aggregationType = entry.getValue();
            Column column = entry.getKey();
            Object value = this.externalResultByColumn.get(column);
            InfoCell infoCell = aggregator.getInfoCell(column);
            if (value != null || aggregationType.isCalculation()) {
                this.setValue(infoCell, value).getDecorator().addStyle("cursor", "pointer").addTitle(aggregationType.getName()).setBold(true);
            } else {
                List columnData = lines.stream().map(lineData -> lineData.getInfoCell(column)).filter((Predicate<InfoCell>)Predicates.notNull()).map(lineData -> lineData.getValueReal() != null ? lineData.getValueReal() : (Comparable)lineData.getValue()).collect(Collectors.toList());
                this.setValue(infoCell, aggregationType.calculate(columnData)).getDecorator().addStyle("cursor", "pointer").addTitle(aggregationType.getName()).setBold(true);
            }
            if (!aggregationType.isCount() && !aggregationType.isCountDistinct()) continue;
            infoCell.getDecorator().addStyle("text-align", "center");
        }
    }

    private InfoCell setValue(InfoCell cell, Object value) {
        Object value2 = value;
        if (value2 instanceof Double) {
            value2 = ConversorToolkit.printNumber((Double)value2);
        } else if (value2 instanceof Number) {
            value2 = value2.toString();
        }
        cell.setValue(value2);
        return cell;
    }
}

