/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.util.List;
import java.util.Objects;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.DataReader;
import org.opensingular.lib.commons.table.DataReaderFixed;
import org.opensingular.lib.commons.table.DataReaderModifier;
import org.opensingular.lib.commons.table.GenerationModifier;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineData;
import org.opensingular.lib.commons.table.TableTool;

class GenerationModifierAgrupar
extends GenerationModifier {
    private final Column column;

    public GenerationModifierAgrupar(TableTool table, Column column) {
        super(table);
        this.column = column;
        for (Column c : this.getColumns()) {
            if (c == column || c.getDataLevel() < column.getDataLevel()) continue;
            c.setDataLevel(c.getDataLevel() + 1);
        }
    }

    @Override
    public DataReader apply(DataReader dataReader) {
        DataReaderFixed group = new DataReaderFixed(null);
        Object currentValue = null;
        DataReaderFixed children = null;
        for (LineData line : dataReader) {
            InfoCell cell = line.getInfoCell(this.column);
            Object valueCellLine = cell.getValue();
            if (!Objects.equals(currentValue, valueCellLine)) {
                children = new DataReaderFixed(dataReader);
                group.add(new LineData(line, new DataReaderModifier(children, this.getNextModifier())));
                currentValue = valueCellLine;
            }
            if (children == null) continue;
            children.add(line);
        }
        return group;
    }

    @Override
    public List<Column> adjustTitles(List<Column> visibleColumns) {
        int posColumn = visibleColumns.indexOf(this.column);
        if (posColumn != -1) {
            int i;
            int posNew = posColumn;
            for (i = posColumn - 1; i >= 0; --i) {
                Column c = visibleColumns.get(i);
                if (c.getDataLevel() <= this.column.getDataLevel()) continue;
                posNew = i;
            }
            if (posNew != posColumn) {
                for (i = posColumn; i > posNew; --i) {
                    visibleColumns.set(i, visibleColumns.get(i - 1));
                }
                visibleColumns.set(posNew, this.column);
            }
        }
        return super.adjustTitles(visibleColumns);
    }
}

