/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.DataReader;
import org.opensingular.lib.commons.table.DataReaderFixed;
import org.opensingular.lib.commons.table.GenerationModifier;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineData;
import org.opensingular.lib.commons.table.TableTool;

public class GenerationModifierFilter
extends GenerationModifier {
    private static final long serialVersionUID = 1L;
    private transient Map<Column, Predicate<InfoCell>> predicates = Maps.newHashMap();

    public GenerationModifierFilter(TableTool table) {
        super(table);
    }

    public GenerationModifierFilter addColumn(Column column, Predicate<InfoCell> filter) {
        this.predicates.put(column, filter);
        return this;
    }

    @Override
    public DataReader apply(DataReader original) {
        List<LineData> lines = original.preLoadDataAndCells(this.getTable()).stream().filter(this::filterLine).collect(Collectors.toList());
        return super.apply(new DataReaderFixed(original, lines));
    }

    private boolean filterLine(LineData line) {
        return this.predicates.entrySet().stream().allMatch(pair -> ((Predicate)pair.getValue()).test(line.getInfoCell((Column)pair.getKey())));
    }
}

