/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.ColumnAggregationType;
import org.opensingular.lib.commons.table.DataReader;
import org.opensingular.lib.commons.table.DataReaderFixed;
import org.opensingular.lib.commons.table.GenerationModifier;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineData;
import org.opensingular.lib.commons.table.TableTool;

class GenerationModifierGroupingWithAggregation
extends GenerationModifier {
    private static final long serialVersionUID = 1L;
    private final List<Column> groupingColumns = new ArrayList<Column>();
    private final Map<Column, ColumnAggregationType> aggregationTypeByColumn = this.createDefaultAggregation();

    public GenerationModifierGroupingWithAggregation(TableTool table) {
        super(table);
    }

    public GenerationModifierGroupingWithAggregation(TableTool table, Map<Column, ColumnAggregationType> aggregationConfiguration) {
        this(table);
        aggregationConfiguration.forEach(this.aggregationTypeByColumn::put);
    }

    public void addColumn(Column column) {
        this.groupingColumns.add(column);
    }

    @Override
    public DataReader apply(DataReader original) {
        Comparator<LineData> sortComparator = this.getSortComparator();
        List<LineData> lines = original.preLoadDataAndCells(this.getTable());
        LinkedListMultimap map = LinkedListMultimap.create();
        if (!lines.isEmpty()) {
            LineData[] pilot = new LineData[]{lines.get(0)};
            lines.stream().sorted(sortComparator).forEach(line -> {
                pilot[0] = sortComparator.compare((LineData)line, pilot[0]) != 0 ? line : pilot[0];
                map.put((Object)pilot[0], line);
            });
        }
        List<LineData> result = map.asMap().values().stream().map(this::fillValues).collect(Collectors.toList());
        return super.apply(new DataReaderFixed(original, result));
    }

    @Override
    public List<Column> adjustTitles(List<Column> visibleColumns) {
        List collect = visibleColumns.stream().skip(1L).collect(Collectors.toList());
        ArrayList<Object> orderedColumns = new ArrayList<Object>();
        this.groupingColumns.forEach(column -> {
            orderedColumns.add(column);
            column.setSuperTitle("");
        });
        orderedColumns.add(null);
        collect.stream().filter(column -> column == null || !orderedColumns.contains(column)).forEach(orderedColumns::add);
        return super.adjustTitles(Lists.newArrayList(orderedColumns));
    }

    private LineData fillValues(Collection<LineData> aggregatedInfo) {
        LineData newLineData = new LineData(this.getTable().newBlankLine());
        LineData reference = aggregatedInfo.stream().findFirst().orElseThrow(() -> new SingularException("N\u00e3o foi possivel encontrar a referencia."));
        this.groupingColumns.forEach(column -> this.copyCellValues(newLineData.getInfoCell((Column)column), reference.getInfoCell((Column)column)));
        this.doAggregation(aggregatedInfo, newLineData);
        return newLineData;
    }

    private void copyCellValues(InfoCell cell, InfoCell reference) {
        cell.setValue(reference.getValue());
        cell.setValueReal(reference.getValueReal());
    }

    public void doAggregation(Collection<LineData> lines, LineData lineData) {
        for (Map.Entry<Column, ColumnAggregationType> entry : this.aggregationTypeByColumn.entrySet()) {
            ColumnAggregationType aggregationType = entry.getValue();
            Column column = entry.getKey();
            if (this.groupingColumns.contains(column)) continue;
            GenerationModifierGroupingWithAggregation.setValue(lineData.getInfoCell(column), aggregationType.calculate(GenerationModifierGroupingWithAggregation.retrieveColumnData(lines, column))).getDecorator().addStyle("cursor", "pointer").addTitle(aggregationType.getName());
        }
    }

    private static List<Object> retrieveColumnData(Collection<LineData> lines, Column column) {
        return lines.stream().map(line -> line.getInfoCell(column)).map(cell -> cell == null ? null : (cell.getValueReal() != null ? cell.getValueReal() : cell.getValue())).collect(Collectors.toList());
    }

    private static InfoCell setValue(InfoCell cell, Object value) {
        if (value instanceof Integer || value instanceof Long || value instanceof Double) {
            cell.setValueReal((Comparable)value);
        }
        cell.setValue(value);
        return cell;
    }

    private Map<Column, ColumnAggregationType> createDefaultAggregation() {
        HashMap<Column, ColumnAggregationType> defaultAggregation = new HashMap<Column, ColumnAggregationType>();
        this.getColumns().forEach(column -> {
            switch (column.getType()) {
                case NUMBER: 
                case INTEGER: 
                case MONEY: {
                    defaultAggregation.put((Column)column, ColumnAggregationType.SUM);
                    break;
                }
            }
        });
        return defaultAggregation;
    }

    private Comparator<LineData> createComparator(Column column) {
        return (o1, o2) -> column.compare(o1.getInfoCell(column), o2.getInfoCell(column));
    }

    private Comparator<LineData> getSortComparator() {
        return this.groupingColumns.stream().map(this::createComparator).reduce(Comparator::thenComparing).orElse(null);
    }
}

