/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.DataReader;
import org.opensingular.lib.commons.table.DataReaderFixed;
import org.opensingular.lib.commons.table.GenerationModifier;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineData;
import org.opensingular.lib.commons.table.TableTool;

class GenerationModifierOrder
extends GenerationModifier {
    private final List<Column> columnsOrder = new ArrayList<Column>();
    private final boolean descending;

    public GenerationModifierOrder(TableTool table, Column c, boolean descending) {
        super(table);
        this.addColumn(c);
        this.descending = descending;
    }

    public void addColumn(Column column) {
        this.columnsOrder.add(column);
    }

    @Override
    public DataReader apply(DataReader original) {
        List<LineData> lines = original.preLoadDataAndCells(this.getTable());
        final Column[] order = this.columnsOrder.toArray(new Column[this.columnsOrder.size()]);
        Comparator<LineData> comp = new Comparator<LineData>(){

            @Override
            public int compare(LineData d1, LineData d2) {
                for (int i = 0; i < order.length; ++i) {
                    int r;
                    InfoCell c1 = d1.getInfoCell(order[i]);
                    InfoCell c2 = d2.getInfoCell(order[i]);
                    int n = r = GenerationModifierOrder.this.descending ? order[i].compare(c2, c1) : order[i].compare(c1, c2);
                    if (r == 0) continue;
                    return r;
                }
                return 0;
            }
        };
        Collections.sort(lines, comp);
        return super.apply(new DataReaderFixed(original, lines));
    }
}

