/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.ColumnTypeProcessor;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineInfo;
import org.opensingular.lib.commons.table.LineReadContext;
import org.opensingular.lib.commons.table.LineReader;
import org.opensingular.lib.commons.table.TreeLineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorUtil
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorUtil.class);

    public static Iterator<?> obterIterador(Object children) {
        if (children == null) {
            return Collections.emptyIterator();
        }
        if (children instanceof Iterator) {
            return (Iterator)children;
        }
        if (children instanceof Iterable) {
            return ((Iterable)children).iterator();
        }
        if (children instanceof Map) {
            return ((Map)children).entrySet().iterator();
        }
        if (children instanceof Collection) {
            return ((Collection)children).iterator();
        }
        if (children.getClass().isArray()) {
            try {
                return Arrays.asList((Object[])children).iterator();
            }
            catch (ClassCastException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                int length = Array.getLength(children);
                ArrayList<Object> c = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    c.add(Array.get(children, i));
                }
                return c.iterator();
            }
        }
        return Iterators.forArray((Object[])new Object[]{children});
    }

    private static boolean isAction(Column column) {
        return column.getProcessor() == ColumnTypeProcessor.ACTION;
    }

    public static boolean isAction(InfoCell cell) {
        return GeneratorUtil.isAction(cell.getColumn());
    }

    public static TreeLineReader toTreeLineReader(final Object list, final LineReader<Object> reader) {
        return new TreeLineReader_(){

            @Override
            public Object getRoots() {
                return list;
            }

            @Override
            public Object getChildren(Object item) {
                return null;
            }

            @Override
            public void retrieveValues(LineReadContext ctx, Object current, LineInfo line) {
                reader.retrieveValues(ctx, current, line);
            }
        };
    }

    private static abstract class TreeLineReader_
    implements TreeLineReader,
    Serializable {
        private TreeLineReader_() {
        }
    }
}

