/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.net.Lnk;
import org.opensingular.lib.commons.net.WebRef;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.DecoratorCell;

public final class InfoCell
implements Serializable {
    private final Column column;
    private transient Object value;
    private transient Comparable<?> valueReal;
    private WebRef link;
    private String linkTitle;
    private String linkTarget;
    private List<WebRef> actions;
    private DecoratorCell decorator;

    InfoCell(Column column) {
        this.column = column;
    }

    public <K> K getValue() {
        return (K)this.value;
    }

    final Number getValueAsNumberOrNull() {
        return this.value instanceof Number ? (Number)((Number)this.value) : (Number)null;
    }

    public InfoCell setValue(Object value) {
        this.value = value;
        return this;
    }

    public final Comparable<?> getValueReal() {
        return this.valueReal;
    }

    final void setValueReal(Comparable<?> valueReal) {
        this.valueReal = valueReal;
    }

    public void addAction(WebRef action) {
        if (this.actions == null) {
            this.actions = new ArrayList<WebRef>(4);
        }
        this.actions.add(action);
    }

    public boolean isActionsEmpty() {
        return this.actions == null || this.actions.isEmpty();
    }

    public List<WebRef> getActions() {
        return this.actions == null ? Collections.emptyList() : this.actions;
    }

    public InfoCell setLink(Lnk link) {
        throw new SingularException("Implementar");
    }

    public InfoCell setLink(String link) {
        return this.setLink(Lnk.of(link));
    }

    public InfoCell setLink(Lnk link, String target) {
        this.setLink(link);
        this.setLinkTarget(target);
        return this;
    }

    public InfoCell setLink(WebRef actionRef) {
        if (actionRef != null && actionRef.hasPermission() && actionRef.appliesToContext()) {
            this.link = actionRef;
            this.setLinkTitle(actionRef.getName());
        }
        return this;
    }

    public WebRef getLink() {
        return this.link;
    }

    public InfoCell setLinkTitle(String hiperLinkTitle) {
        this.linkTitle = hiperLinkTitle;
        return this;
    }

    public String getLinkTitle() {
        return this.linkTitle;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String hiperLinkTarget) {
        this.linkTarget = hiperLinkTarget;
    }

    public boolean temDecorador() {
        return this.decorator != null;
    }

    public DecoratorCell getDecorator() {
        if (this.decorator == null) {
            this.decorator = this.createTempDecorator();
        }
        return this.decorator;
    }

    public DecoratorCell createTempDecorator() {
        if (this.decorator == null) {
            return new DecoratorCell(this.column.getDecoratorValues());
        }
        return new DecoratorCell(this.decorator);
    }

    public Column getColumn() {
        return this.column;
    }
}

