/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.DataReader;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineInfo;
import org.opensingular.lib.commons.table.LineReadContext;

public final class LineData {
    private DataReader parent;
    private final Object value;
    private DataReader children;
    private Integer lines;
    private LineInfo line;

    LineData(LineInfo line) {
        this.value = null;
        this.line = line;
    }

    public LineData(DataReader parent, Object value) {
        this.parent = parent;
        this.value = value;
    }

    LineData(LineData original, DataReader newChildren) {
        this.parent = null;
        this.value = original.value;
        this.line = original.line;
        this.children = newChildren;
    }

    public Object getValue() {
        return this.value;
    }

    public DataReader getChildrenReader() {
        if (this.children == null && this.parent != null) {
            this.children = this.parent.getChildren(this);
        }
        return this.children;
    }

    public void setParentReader(DataReader newReader) {
        this.parent = newReader;
    }

    public List<LineData> getChildren() {
        DataReader childrenReader = this.getChildrenReader();
        if (childrenReader != null) {
            return childrenReader.preLoadData();
        }
        return Collections.emptyList();
    }

    public LineInfo retrieveValues(LineReadContext ctx, int numLevel, boolean cleanContextAndColumns, boolean save) {
        if (this.line == null) {
            if (cleanContextAndColumns) {
                // empty if block
            }
            LineInfo result = this.parent.retrieveValues(ctx, this);
            if (save) {
                this.line = result;
            }
            return result;
        }
        return this.line;
    }

    public LineInfo getLine() {
        return this.line;
    }

    public InfoCell getInfoCell(Column c) {
        return this.line.get(c);
    }

    public <K> K getValue(int index) {
        return this.getValue(index, null);
    }

    public <K> K getValue(int index, K defaultValue) {
        InfoCell infoCell = this.line.get(index);
        Object value = infoCell.getValue();
        return value == null ? defaultValue : value;
    }

    public int getLines() {
        if (this.lines == null) {
            this.lines = this.getChildren().stream().mapToInt(p -> p.getLines()).sum();
            if (this.lines == 0) {
                this.lines = 1;
            }
        }
        return this.lines;
    }

    public List<LineData[]> normalizeLevels(int max) {
        ArrayList<LineData[]> list = new ArrayList<LineData[]>(this.getLines());
        LineData[] newLine = new LineData[max];
        newLine[0] = this;
        list.add(newLine);
        this.normalizeChildren(list, 1, max);
        return list;
    }

    private void normalizeChildren(List<LineData[]> list, int depth, int max) {
        if (depth > max + 2) {
            return;
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            LineData[] currentLine;
            LineData child = this.getChildren().get(i);
            if (i == 0) {
                currentLine = list.get(list.size() - 1);
            } else {
                currentLine = new LineData[max];
                list.add(currentLine);
            }
            currentLine[depth] = child;
            child.normalizeChildren(list, depth + 1, max);
        }
    }
}

