/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import javax.annotation.Nonnull;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.Decorator;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.TableTool;

public class LineInfo {
    private final TableTool table;
    private final InfoCell[] cells;
    private Decorator decorator_;
    private boolean showLine = true;
    private int level;

    LineInfo(TableTool table) {
        this.table = table;
        this.cells = new InfoCell[table.getColumns().size()];
    }

    public Decorator getDecorator() {
        if (this.decorator_ == null) {
            this.decorator_ = new Decorator();
        }
        return this.decorator_;
    }

    public Decorator createTempDecorator() {
        return new Decorator(this.decorator_);
    }

    final boolean isShowLine() {
        return this.showLine;
    }

    public void setShowLine(boolean showLine) {
        this.showLine = showLine;
    }

    void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    final void setCell(int index, InfoCell cell) {
        this.cells[index] = cell;
    }

    @Nonnull
    public InfoCell get(@Nonnull Column c) {
        return this.get(c.getIndex());
    }

    @Nonnull
    public InfoCell get(int index) {
        if (this.cells[index] == null) {
            this.cells[index] = new InfoCell(this.table.getColumn(index));
        }
        return this.cells[index];
    }
}

