/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.ColumnTypeProcessor;
import org.opensingular.lib.commons.table.DecoratorCell;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.OutputTableContext;

public class OutputCellContext {
    private final OutputTableContext outputTableContext;
    private final InfoCell cell;
    private Object value;
    private DecoratorCell tempDecorator;
    private int level;
    private ColumnTypeProcessor columnProcessor;
    private boolean columnWithSeparator;

    OutputCellContext(@Nonnull OutputTableContext outputTableContext, @Nonnull InfoCell cell, @Nonnull DecoratorCell tempDecorator) {
        this.outputTableContext = outputTableContext;
        this.cell = cell;
        this.value = cell.getValue();
        this.columnProcessor = cell.getColumn().getProcessor();
        this.tempDecorator = tempDecorator;
    }

    @Nonnull
    public OutputTableContext getOutputTableContext() {
        return this.outputTableContext;
    }

    @Nonnull
    public InfoCell getCell() {
        return this.cell;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    void setValue(Object value) {
        this.value = value;
    }

    @Nonnull
    public DecoratorCell getTempDecorator() {
        return this.tempDecorator;
    }

    public int getLevel() {
        return this.level;
    }

    OutputCellContext setLevel(int level) {
        this.level = level;
        return this;
    }

    @Nonnull
    public ColumnTypeProcessor getColumnProcessor() {
        return this.columnProcessor;
    }

    void setColumnProcessor(@Nonnull ColumnTypeProcessor columnProcessor) {
        this.columnProcessor = columnProcessor;
    }

    public boolean isNullContent() {
        return this.columnProcessor.isNullContent(this.cell);
    }

    public boolean isActionCell() {
        return this.columnProcessor == ColumnTypeProcessor.ACTION;
    }

    @Nonnull
    public Column getColumn() {
        return this.cell.getColumn();
    }

    public String generateFormatDisplayString() {
        return this.generateFormatDisplayString(this.value);
    }

    public String generateFormatDisplayString(Object targetValue) {
        ColumnTypeProcessor.PrintResult result = this.columnProcessor.generatePrintValue(this.getColumn(), targetValue);
        if (result.isDefined()) {
            return this.resolveMaxLength(result.getContent(), this.tempDecorator);
        }
        if (targetValue == null) {
            return null;
        }
        return this.resolveMaxLength(targetValue.toString(), this.tempDecorator);
    }

    private String resolveMaxLength(String content, DecoratorCell tempDecorator) {
        if (content != null && tempDecorator.getMaxTextLength() != null && content.length() > tempDecorator.getMaxTextLength()) {
            return content.substring(0, tempDecorator.getMaxTextLength());
        }
        return content;
    }

    public void setColumnWithSeparator(boolean columnWithSeparator) {
        this.columnWithSeparator = columnWithSeparator;
    }

    public boolean isColumnWithSeparator() {
        return this.columnWithSeparator;
    }
}

